// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.SoftDeletesConverter))]
public sealed partial class SoftDeletes
{
#if NET7_0_OR_GREATER
	public SoftDeletes()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SoftDeletes()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SoftDeletes(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Indicates whether soft deletes are enabled on the index.
	/// </para>
	/// </summary>
	public bool? Enabled { get; set; }

	/// <summary>
	/// <para>
	/// The maximum period to retain a shard history retention lease before it is considered expired.
	/// Shard history retention leases ensure that soft deletes are retained during merges on the Lucene
	/// index. If a soft delete is merged away before it can be replicated to a follower the following
	/// process will fail due to incomplete history on the leader.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RetentionLease? RetentionLease { get; set; }
}

public readonly partial struct SoftDeletesDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SoftDeletesDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SoftDeletesDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes instance) => new Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes(Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Indicates whether soft deletes are enabled on the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum period to retain a shard history retention lease before it is considered expired.
	/// Shard history retention leases ensure that soft deletes are retained during merges on the Lucene
	/// index. If a soft delete is merged away before it can be replicated to a follower the following
	/// process will fail due to incomplete history on the leader.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor RetentionLease(Elastic.Clients.Elasticsearch.IndexManagement.RetentionLease? value)
	{
		Instance.RetentionLease = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum period to retain a shard history retention lease before it is considered expired.
	/// Shard history retention leases ensure that soft deletes are retained during merges on the Lucene
	/// index. If a soft delete is merged away before it can be replicated to a follower the following
	/// process will fail due to incomplete history on the leader.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor RetentionLease(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RetentionLeaseDescriptor> action)
	{
		Instance.RetentionLease = Elastic.Clients.Elasticsearch.IndexManagement.RetentionLeaseDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}