// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class SlowlogTresholdLevelsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdLevels>
{
	private static readonly System.Text.Json.JsonEncodedText PropDebug = System.Text.Json.JsonEncodedText.Encode("debug");
	private static readonly System.Text.Json.JsonEncodedText PropInfo = System.Text.Json.JsonEncodedText.Encode("info");
	private static readonly System.Text.Json.JsonEncodedText PropTrace = System.Text.Json.JsonEncodedText.Encode("trace");
	private static readonly System.Text.Json.JsonEncodedText PropWarn = System.Text.Json.JsonEncodedText.Encode("warn");

	public override Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdLevels Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propDebug = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propInfo = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propTrace = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propWarn = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propDebug.TryReadProperty(ref reader, options, PropDebug, null))
			{
				continue;
			}

			if (propInfo.TryReadProperty(ref reader, options, PropInfo, null))
			{
				continue;
			}

			if (propTrace.TryReadProperty(ref reader, options, PropTrace, null))
			{
				continue;
			}

			if (propWarn.TryReadProperty(ref reader, options, PropWarn, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdLevels(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Debug = propDebug.Value,
			Info = propInfo.Value,
			Trace = propTrace.Value,
			Warn = propWarn.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdLevels value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropDebug, value.Debug, null, null);
		writer.WriteProperty(options, PropInfo, value.Info, null, null);
		writer.WriteProperty(options, PropTrace, value.Trace, null, null);
		writer.WriteProperty(options, PropWarn, value.Warn, null, null);
		writer.WriteEndObject();
	}
}