// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.SlowlogSettingsConverter))]
public sealed partial class SlowlogSettings
{
#if NET7_0_OR_GREATER
	public SlowlogSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SlowlogSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SlowlogSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? Level { get; set; }
	public bool? Reformat { get; set; }
	public int? Source { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholds? Threshold { get; set; }
}

public readonly partial struct SlowlogSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SlowlogSettingsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SlowlogSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettings instance) => new Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettings(Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor Level(string? value)
	{
		Instance.Level = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor Reformat(bool? value = true)
	{
		Instance.Reformat = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor Source(int? value)
	{
		Instance.Source = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor Threshold(Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholds? value)
	{
		Instance.Threshold = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor Threshold()
	{
		Instance.Threshold = Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor Threshold(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdsDescriptor>? action)
	{
		Instance.Threshold = Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdsDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettings Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}