// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class ShardStoreStatusConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAll = System.Text.Json.JsonEncodedText.Encode("all");
	private static readonly System.Text.Json.JsonEncodedText MemberGreen = System.Text.Json.JsonEncodedText.Encode("green");
	private static readonly System.Text.Json.JsonEncodedText MemberRed = System.Text.Json.JsonEncodedText.Encode("red");
	private static readonly System.Text.Json.JsonEncodedText MemberYellow = System.Text.Json.JsonEncodedText.Encode("yellow");

	public override Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAll))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.All;
		}

		if (reader.ValueTextEquals(MemberGreen))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.Green;
		}

		if (reader.ValueTextEquals(MemberRed))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.Red;
		}

		if (reader.ValueTextEquals(MemberYellow))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.Yellow;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAll.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.All;
		}

		if (string.Equals(value, MemberGreen.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.Green;
		}

		if (string.Equals(value, MemberRed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.Red;
		}

		if (string.Equals(value, MemberYellow.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.Yellow;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.All:
				writer.WriteStringValue(MemberAll);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.Green:
				writer.WriteStringValue(MemberGreen);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.Red:
				writer.WriteStringValue(MemberRed);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus.Yellow:
				writer.WriteStringValue(MemberYellow);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}