// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class ShardStoreAllocationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation>
{
	private static readonly System.Text.Json.JsonEncodedText MemberPrimary = System.Text.Json.JsonEncodedText.Encode("primary");
	private static readonly System.Text.Json.JsonEncodedText MemberReplica = System.Text.Json.JsonEncodedText.Encode("replica");
	private static readonly System.Text.Json.JsonEncodedText MemberUnused = System.Text.Json.JsonEncodedText.Encode("unused");

	public override Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberPrimary))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation.Primary;
		}

		if (reader.ValueTextEquals(MemberReplica))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation.Replica;
		}

		if (reader.ValueTextEquals(MemberUnused))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation.Unused;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberPrimary.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation.Primary;
		}

		if (string.Equals(value, MemberReplica.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation.Replica;
		}

		if (string.Equals(value, MemberUnused.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation.Unused;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation.Primary:
				writer.WriteStringValue(MemberPrimary);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation.Replica:
				writer.WriteStringValue(MemberReplica);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation.Unused:
				writer.WriteStringValue(MemberUnused);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.ShardStoreAllocation value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}