// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class ShardSequenceNumberConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.ShardSequenceNumber>
{
	private static readonly System.Text.Json.JsonEncodedText PropGlobalCheckpoint = System.Text.Json.JsonEncodedText.Encode("global_checkpoint");
	private static readonly System.Text.Json.JsonEncodedText PropLocalCheckpoint = System.Text.Json.JsonEncodedText.Encode("local_checkpoint");
	private static readonly System.Text.Json.JsonEncodedText PropMaxSeqNo = System.Text.Json.JsonEncodedText.Encode("max_seq_no");

	public override Elastic.Clients.Elasticsearch.IndexManagement.ShardSequenceNumber Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long> propGlobalCheckpoint = default;
		LocalJsonValue<long> propLocalCheckpoint = default;
		LocalJsonValue<long> propMaxSeqNo = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propGlobalCheckpoint.TryReadProperty(ref reader, options, PropGlobalCheckpoint, null))
			{
				continue;
			}

			if (propLocalCheckpoint.TryReadProperty(ref reader, options, PropLocalCheckpoint, null))
			{
				continue;
			}

			if (propMaxSeqNo.TryReadProperty(ref reader, options, PropMaxSeqNo, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.ShardSequenceNumber(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			GlobalCheckpoint = propGlobalCheckpoint.Value,
			LocalCheckpoint = propLocalCheckpoint.Value,
			MaxSeqNo = propMaxSeqNo.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.ShardSequenceNumber value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropGlobalCheckpoint, value.GlobalCheckpoint, null, null);
		writer.WriteProperty(options, PropLocalCheckpoint, value.LocalCheckpoint, null, null);
		writer.WriteProperty(options, PropMaxSeqNo, value.MaxSeqNo, null, null);
		writer.WriteEndObject();
	}
}