// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class ShardRoutingStateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState>
{
	private static readonly System.Text.Json.JsonEncodedText MemberInitializing = System.Text.Json.JsonEncodedText.Encode("INITIALIZING");
	private static readonly System.Text.Json.JsonEncodedText MemberRelocating = System.Text.Json.JsonEncodedText.Encode("RELOCATING");
	private static readonly System.Text.Json.JsonEncodedText MemberStarted = System.Text.Json.JsonEncodedText.Encode("STARTED");
	private static readonly System.Text.Json.JsonEncodedText MemberUnassigned = System.Text.Json.JsonEncodedText.Encode("UNASSIGNED");

	public override Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberInitializing))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Initializing;
		}

		if (reader.ValueTextEquals(MemberRelocating))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Relocating;
		}

		if (reader.ValueTextEquals(MemberStarted))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Started;
		}

		if (reader.ValueTextEquals(MemberUnassigned))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Unassigned;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberInitializing.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Initializing;
		}

		if (string.Equals(value, MemberRelocating.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Relocating;
		}

		if (string.Equals(value, MemberStarted.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Started;
		}

		if (string.Equals(value, MemberUnassigned.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Unassigned;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Initializing:
				writer.WriteStringValue(MemberInitializing);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Relocating:
				writer.WriteStringValue(MemberRelocating);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Started:
				writer.WriteStringValue(MemberStarted);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState.Unassigned:
				writer.WriteStringValue(MemberUnassigned);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.ShardRoutingState value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}