// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class SettingsSimilarityDfrConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfr>
{
	private static readonly System.Text.Json.JsonEncodedText PropAfterEffect = System.Text.Json.JsonEncodedText.Encode("after_effect");
	private static readonly System.Text.Json.JsonEncodedText PropBasicModel = System.Text.Json.JsonEncodedText.Encode("basic_model");
	private static readonly System.Text.Json.JsonEncodedText PropNormalization = System.Text.Json.JsonEncodedText.Encode("normalization");
	private static readonly System.Text.Json.JsonEncodedText PropType = System.Text.Json.JsonEncodedText.Encode("type");

	public override Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfr Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.DFRAfterEffect> propAfterEffect = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.DFRBasicModel> propBasicModel = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Normalization> propNormalization = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAfterEffect.TryReadProperty(ref reader, options, PropAfterEffect, null))
			{
				continue;
			}

			if (propBasicModel.TryReadProperty(ref reader, options, PropBasicModel, null))
			{
				continue;
			}

			if (propNormalization.TryReadProperty(ref reader, options, PropNormalization, null))
			{
				continue;
			}

			if (reader.ValueTextEquals(PropType))
			{
				reader.SafeSkip();
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfr(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AfterEffect = propAfterEffect.Value,
			BasicModel = propBasicModel.Value,
			Normalization = propNormalization.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfr value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAfterEffect, value.AfterEffect, null, null);
		writer.WriteProperty(options, PropBasicModel, value.BasicModel, null, null);
		writer.WriteProperty(options, PropNormalization, value.Normalization, null, null);
		writer.WriteProperty(options, PropType, value.Type, null, null);
		writer.WriteEndObject();
	}
}