// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class ISettingsSimilarityConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.ISettingsSimilarity>
{
	private static readonly System.Text.Json.JsonEncodedText PropDiscriminator = System.Text.Json.JsonEncodedText.Encode("type");

	public override Elastic.Clients.Elasticsearch.IndexManagement.ISettingsSimilarity Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		var readerSnapshot = reader;
		string? discriminator = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.TryReadProperty(options, PropDiscriminator, ref discriminator, null))
			{
				break;
			}

			reader.SafeSkip();
		}

		reader = readerSnapshot;
		return discriminator switch
		{
			"BM25" => reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBm25>(options, null),
			"boolean" => reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBoolean>(options, null),
			"DFI" => reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfi>(options, null),
			"DFR" => reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfr>(options, null),
			"IB" => reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityIb>(options, null),
			"LMDirichlet" => reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmd>(options, null),
			"LMJelinekMercer" => reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmj>(options, null),
			"scripted" => reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityScripted>(options, null),
			_ => throw new System.Text.Json.JsonException($"Variant '{discriminator}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.ISettingsSimilarity)}'.")
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.ISettingsSimilarity value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value.Type)
		{
			case "BM25":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBm25)value, null);
				break;
			case "boolean":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBoolean)value, null);
				break;
			case "DFI":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfi)value, null);
				break;
			case "DFR":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfr)value, null);
				break;
			case "IB":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityIb)value, null);
				break;
			case "LMDirichlet":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmd)value, null);
				break;
			case "LMJelinekMercer":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmj)value, null);
				break;
			case "scripted":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityScripted)value, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.Type}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.ISettingsSimilarity)}'.");
		}
	}
}