// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.SettingsSimilaritiesConverter))]
public sealed partial class SettingsSimilarities : Elastic.Clients.Elasticsearch.IsADictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.ISettingsSimilarity>
{
	public SettingsSimilarities()
	{
	}

	public SettingsSimilarities(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.ISettingsSimilarity> backingDictionary) : base(backingDictionary)
	{
	}

	public void Add(string key, Elastic.Clients.Elasticsearch.IndexManagement.ISettingsSimilarity value) => BackingDictionary.Add(Sanitize(key), value);
	public bool TryGetSettingsSimilarity(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out Elastic.Clients.Elasticsearch.IndexManagement.ISettingsSimilarity value) => BackingDictionary.TryGetValue(Sanitize(key), out value);

	public bool TryGetSettingsSimilarity<T>(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out T? value) where T : class, ISettingsSimilarity
	{
		if (BackingDictionary.TryGetValue(Sanitize(key), out var matchedValue) && matchedValue is T finalValue)
		{
			value = finalValue;
			return true;
		}

		value = null;
		return false;
	}
}

public readonly partial struct SettingsSimilaritiesDescriptor
{
	private readonly Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarities _items = new();

	private Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarities Value => _items;

	public SettingsSimilaritiesDescriptor()
	{
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Bm25(string key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBm25 value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Bm25(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBm25Descriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Bm25(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBm25Descriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBm25Descriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Boolean(string key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBoolean value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Boolean(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBooleanDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Boolean(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBooleanDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityBooleanDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Dfi(string key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfi value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Dfi(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfiDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfiDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Dfr(string key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfr value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Dfr(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfrDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityDfrDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Ib(string key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityIb value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Ib(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityIbDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityIbDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Lmd(string key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmd value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Lmd(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmdDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Lmd(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmdDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmdDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Lmj(string key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmj value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Lmj(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmjDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Lmj(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmjDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityLmjDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Scripted(string key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityScripted value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor Scripted(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityScriptedDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarityScriptedDescriptor.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarities Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarities();
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor();
		action.Invoke(builder);
		return builder.Value;
	}
}