// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.SettingsSearchConverter))]
public sealed partial class SettingsSearch
{
#if NET7_0_OR_GREATER
	public SettingsSearch()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SettingsSearch()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SettingsSearch(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SearchIdle? Idle { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettings? Slowlog { get; set; }
}

public readonly partial struct SettingsSearchDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SettingsSearchDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SettingsSearchDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch instance) => new Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch(Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor Idle(Elastic.Clients.Elasticsearch.IndexManagement.SearchIdle? value)
	{
		Instance.Idle = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor Idle()
	{
		Instance.Idle = Elastic.Clients.Elasticsearch.IndexManagement.SearchIdleDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor Idle(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SearchIdleDescriptor>? action)
	{
		Instance.Idle = Elastic.Clients.Elasticsearch.IndexManagement.SearchIdleDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor Slowlog(Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettings? value)
	{
		Instance.Slowlog = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor Slowlog()
	{
		Instance.Slowlog = Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor Slowlog(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor>? action)
	{
		Instance.Slowlog = Elastic.Clients.Elasticsearch.IndexManagement.SlowlogSettingsDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}