// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class SegmentSortOrderConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAsc = System.Text.Json.JsonEncodedText.Encode("asc");
	private static readonly System.Text.Json.JsonEncodedText MemberAsc1 = System.Text.Json.JsonEncodedText.Encode("ASC");
	private static readonly System.Text.Json.JsonEncodedText MemberDesc = System.Text.Json.JsonEncodedText.Encode("desc");
	private static readonly System.Text.Json.JsonEncodedText MemberDesc1 = System.Text.Json.JsonEncodedText.Encode("DESC");

	public override Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAsc) || reader.ValueTextEquals(MemberAsc1))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder.Asc;
		}

		if (reader.ValueTextEquals(MemberDesc) || reader.ValueTextEquals(MemberDesc1))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder.Desc;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAsc.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberAsc1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder.Asc;
		}

		if (string.Equals(value, MemberDesc.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberDesc1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder.Desc;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder.Asc:
				writer.WriteStringValue(MemberAsc);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder.Desc:
				writer.WriteStringValue(MemberDesc);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortOrder value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}