// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class SegmentSortModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberMax = System.Text.Json.JsonEncodedText.Encode("max");
	private static readonly System.Text.Json.JsonEncodedText MemberMax1 = System.Text.Json.JsonEncodedText.Encode("MAX");
	private static readonly System.Text.Json.JsonEncodedText MemberMin = System.Text.Json.JsonEncodedText.Encode("min");
	private static readonly System.Text.Json.JsonEncodedText MemberMin1 = System.Text.Json.JsonEncodedText.Encode("MIN");

	public override Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberMax) || reader.ValueTextEquals(MemberMax1))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode.Max;
		}

		if (reader.ValueTextEquals(MemberMin) || reader.ValueTextEquals(MemberMin1))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode.Min;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberMax.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberMax1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode.Max;
		}

		if (string.Equals(value, MemberMin.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberMin1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode.Min;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode.Max:
				writer.WriteStringValue(MemberMax);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode.Min:
				writer.WriteStringValue(MemberMin);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.SegmentSortMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}