// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.RolloverConditionsConverter))]
public sealed partial class RolloverConditions
{
#if NET7_0_OR_GREATER
	public RolloverConditions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RolloverConditions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RolloverConditions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Duration? MaxAge { get; set; }
	public System.TimeSpan? MaxAgeMillis { get; set; }
	public long? MaxDocs { get; set; }
	public long? MaxPrimaryShardDocs { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MaxPrimaryShardSize { get; set; }
	public long? MaxPrimaryShardSizeBytes { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MaxSize { get; set; }
	public long? MaxSizeBytes { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? MinAge { get; set; }
	public long? MinDocs { get; set; }
	public long? MinPrimaryShardDocs { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MinPrimaryShardSize { get; set; }
	public long? MinPrimaryShardSizeBytes { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MinSize { get; set; }
	public long? MinSizeBytes { get; set; }
}

public readonly partial struct RolloverConditionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RolloverConditionsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RolloverConditionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditions instance) => new Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditions(Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MaxAge(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MaxAge = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MaxAgeMillis(System.TimeSpan? value)
	{
		Instance.MaxAgeMillis = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MaxDocs(long? value)
	{
		Instance.MaxDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MaxPrimaryShardDocs(long? value)
	{
		Instance.MaxPrimaryShardDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MaxPrimaryShardSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxPrimaryShardSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MaxPrimaryShardSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxPrimaryShardSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MaxPrimaryShardSizeBytes(long? value)
	{
		Instance.MaxPrimaryShardSizeBytes = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MaxSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MaxSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MaxSizeBytes(long? value)
	{
		Instance.MaxSizeBytes = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MinAge(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MinAge = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MinDocs(long? value)
	{
		Instance.MinDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MinPrimaryShardDocs(long? value)
	{
		Instance.MinPrimaryShardDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MinPrimaryShardSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MinPrimaryShardSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MinPrimaryShardSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MinPrimaryShardSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MinPrimaryShardSizeBytes(long? value)
	{
		Instance.MinPrimaryShardSizeBytes = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MinSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MinSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MinSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MinSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor MinSizeBytes(long? value)
	{
		Instance.MinSizeBytes = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditions Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditionsDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.RolloverConditions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}