// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

/// <summary>
/// <para>
/// Provides information about each cluster request relevant to doing a cross-cluster search.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.ResolveClusterInfoConverter))]
public sealed partial class ResolveClusterInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ResolveClusterInfo(bool connected, bool skipUnavailable)
	{
		Connected = connected;
		SkipUnavailable = skipUnavailable;
	}
#if NET7_0_OR_GREATER
	public ResolveClusterInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ResolveClusterInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ResolveClusterInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Whether the remote cluster is connected to the local (querying) cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Connected { get; set; }

	/// <summary>
	/// <para>
	/// Provides error messages that are likely to occur if you do a search with this index expression
	/// on the specified cluster (for example, lack of security privileges to query an index).
	/// </para>
	/// </summary>
	public string? Error { get; set; }

	/// <summary>
	/// <para>
	/// Whether the index expression provided in the request matches any indices, aliases or data streams
	/// on the cluster.
	/// </para>
	/// </summary>
	public bool? MatchingIndices { get; set; }

	/// <summary>
	/// <para>
	/// The <c>skip_unavailable</c> setting for a remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool SkipUnavailable { get; set; }

	/// <summary>
	/// <para>
	/// Provides version information about the cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ElasticsearchVersionMinInfo? Version { get; set; }
}