// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.RemoveIndexActionConverter))]
public sealed partial class RemoveIndexAction
{
#if NET7_0_OR_GREATER
	public RemoveIndexAction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RemoveIndexAction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RemoveIndexAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Data stream or index for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? Index { get; set; }

	/// <summary>
	/// <para>
	/// Data streams or indices for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Indices? Indices { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias must exist to perform the action.
	/// </para>
	/// </summary>
	public bool? MustExist { get; set; }
}

public readonly partial struct RemoveIndexActionDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoveIndexActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoveIndexActionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction instance) => new Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction(Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Data stream or index for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Data streams or indices for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias must exist to perform the action.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor MustExist(bool? value = true)
	{
		Instance.MustExist = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}