// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.RemoveActionConverter))]
public sealed partial class RemoveAction
{
#if NET7_0_OR_GREATER
	public RemoveAction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RemoveAction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RemoveAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Alias for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexAlias? Alias { get; set; }

	/// <summary>
	/// <para>
	/// Aliases for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexAlias>? Aliases { get; set; }

	/// <summary>
	/// <para>
	/// Data stream or index for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? Index { get; set; }

	/// <summary>
	/// <para>
	/// Data streams or indices for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Indices? Indices { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias must exist to perform the action.
	/// </para>
	/// </summary>
	public bool? MustExist { get; set; }
}

public readonly partial struct RemoveActionDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoveActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoveActionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction instance) => new Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction(Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Alias for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor Alias(Elastic.Clients.Elasticsearch.IndexAlias? value)
	{
		Instance.Alias = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor Aliases(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexAlias>? value)
	{
		Instance.Aliases = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor Aliases(params Elastic.Clients.Elasticsearch.IndexAlias[] values)
	{
		Instance.Aliases = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Data stream or index for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Data streams or indices for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias must exist to perform the action.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor MustExist(bool? value = true)
	{
		Instance.MustExist = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}