// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class NumericFielddataFormatConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat>
{
	private static readonly System.Text.Json.JsonEncodedText MemberArray = System.Text.Json.JsonEncodedText.Encode("array");
	private static readonly System.Text.Json.JsonEncodedText MemberDisabled = System.Text.Json.JsonEncodedText.Encode("disabled");

	public override Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberArray))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat.Array;
		}

		if (reader.ValueTextEquals(MemberDisabled))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat.Disabled;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberArray.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat.Array;
		}

		if (string.Equals(value, MemberDisabled.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat.Disabled;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat.Array:
				writer.WriteStringValue(MemberArray);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat.Disabled:
				writer.WriteStringValue(MemberDisabled);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.NumericFielddataFormat value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}