// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.MigrateReindexConverter))]
public sealed partial class MigrateReindex
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MigrateReindex(Elastic.Clients.Elasticsearch.IndexManagement.ModeEnum mode, Elastic.Clients.Elasticsearch.IndexManagement.SourceIndex source)
	{
		Mode = mode;
		Source = source;
	}
#if NET7_0_OR_GREATER
	public MigrateReindex()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public MigrateReindex()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MigrateReindex(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Reindex mode. Currently only 'upgrade' is supported.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.ModeEnum Mode { get; set; }

	/// <summary>
	/// <para>
	/// The source index or data stream (only data streams are currently supported).
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.SourceIndex Source { get; set; }
}

public readonly partial struct MigrateReindexDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindex Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MigrateReindexDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindex instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MigrateReindexDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindex(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindex instance) => new Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindex(Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Reindex mode. Currently only 'upgrade' is supported.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexDescriptor Mode(Elastic.Clients.Elasticsearch.IndexManagement.ModeEnum value)
	{
		Instance.Mode = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source index or data stream (only data streams are currently supported).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexDescriptor Source(Elastic.Clients.Elasticsearch.IndexManagement.SourceIndex value)
	{
		Instance.Source = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The source index or data stream (only data streams are currently supported).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexDescriptor Source(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SourceIndexDescriptor> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.IndexManagement.SourceIndexDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindex Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindexDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.MigrateReindex(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}