// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.MappingLimitSettingsTotalFieldsConverter))]
public sealed partial class MappingLimitSettingsTotalFields
{
#if NET7_0_OR_GREATER
	public MappingLimitSettingsTotalFields()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public MappingLimitSettingsTotalFields()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MappingLimitSettingsTotalFields(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// This setting determines what happens when a dynamically mapped field would exceed the total fields limit. When set
	/// to false (the default), the index request of the document that tries to add a dynamic field to the mapping will fail
	/// with the message Limit of total fields [X] has been exceeded. When set to true, the index request will not fail.
	/// Instead, fields that would exceed the limit are not added to the mapping, similar to dynamic: false.
	/// The fields that were not added to the mapping will be added to the _ignored field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<bool, string>? IgnoreDynamicBeyondLimit { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of fields in an index. Field and object mappings, as well as field aliases count towards this limit.
	/// The limit is in place to prevent mappings and searches from becoming too large. Higher values can lead to performance
	/// degradations and memory issues, especially in clusters with a high load or few resources.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Union<long, string>? Limit { get; set; }
}

public readonly partial struct MappingLimitSettingsTotalFieldsDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFields Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MappingLimitSettingsTotalFieldsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFields instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MappingLimitSettingsTotalFieldsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFields(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFieldsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFields instance) => new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFieldsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFields(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFieldsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// This setting determines what happens when a dynamically mapped field would exceed the total fields limit. When set
	/// to false (the default), the index request of the document that tries to add a dynamic field to the mapping will fail
	/// with the message Limit of total fields [X] has been exceeded. When set to true, the index request will not fail.
	/// Instead, fields that would exceed the limit are not added to the mapping, similar to dynamic: false.
	/// The fields that were not added to the mapping will be added to the _ignored field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFieldsDescriptor IgnoreDynamicBeyondLimit(Elastic.Clients.Elasticsearch.Union<bool, string>? value)
	{
		Instance.IgnoreDynamicBeyondLimit = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of fields in an index. Field and object mappings, as well as field aliases count towards this limit.
	/// The limit is in place to prevent mappings and searches from becoming too large. Higher values can lead to performance
	/// degradations and memory issues, especially in clusters with a high load or few resources.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFieldsDescriptor Limit(Elastic.Clients.Elasticsearch.Union<long, string>? value)
	{
		Instance.Limit = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFields Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFieldsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFields(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFieldsDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFields(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}