// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.MappingLimitSettingsNestedObjectsConverter))]
public sealed partial class MappingLimitSettingsNestedObjects
{
#if NET7_0_OR_GREATER
	public MappingLimitSettingsNestedObjects()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public MappingLimitSettingsNestedObjects()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MappingLimitSettingsNestedObjects(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps
	/// to prevent out of memory errors when a document contains too many nested objects.
	/// </para>
	/// </summary>
	public long? Limit { get; set; }
}

public readonly partial struct MappingLimitSettingsNestedObjectsDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjects Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MappingLimitSettingsNestedObjectsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjects instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MappingLimitSettingsNestedObjectsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjects(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjectsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjects instance) => new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjectsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjects(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjectsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps
	/// to prevent out of memory errors when a document contains too many nested objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjectsDescriptor Limit(long? value)
	{
		Instance.Limit = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjects Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjectsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjects(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjectsDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjects(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}