// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.MappingLimitSettingsNestedFieldsConverter))]
public sealed partial class MappingLimitSettingsNestedFields
{
#if NET7_0_OR_GREATER
	public MappingLimitSettingsNestedFields()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public MappingLimitSettingsNestedFields()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MappingLimitSettingsNestedFields(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The maximum number of distinct nested mappings in an index. The nested type should only be used in special cases, when
	/// arrays of objects need to be queried independently of each other. To safeguard against poorly designed mappings, this
	/// setting limits the number of unique nested types per index.
	/// </para>
	/// </summary>
	public long? Limit { get; set; }
}

public readonly partial struct MappingLimitSettingsNestedFieldsDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFields Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MappingLimitSettingsNestedFieldsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFields instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MappingLimitSettingsNestedFieldsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFields(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFieldsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFields instance) => new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFieldsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFields(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFieldsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The maximum number of distinct nested mappings in an index. The nested type should only be used in special cases, when
	/// arrays of objects need to be queried independently of each other. To safeguard against poorly designed mappings, this
	/// setting limits the number of unique nested types per index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFieldsDescriptor Limit(long? value)
	{
		Instance.Limit = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFields Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFieldsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFields(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFieldsDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFields(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}