// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.MappingLimitSettingsDepthConverter))]
public sealed partial class MappingLimitSettingsDepth
{
#if NET7_0_OR_GREATER
	public MappingLimitSettingsDepth()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public MappingLimitSettingsDepth()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MappingLimitSettingsDepth(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The maximum depth for a field, which is measured as the number of inner objects. For instance, if all fields are defined
	/// at the root object level, then the depth is 1. If there is one object mapping, then the depth is 2, etc.
	/// </para>
	/// </summary>
	public long? Limit { get; set; }
}

public readonly partial struct MappingLimitSettingsDepthDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepth Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MappingLimitSettingsDepthDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepth instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MappingLimitSettingsDepthDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepth(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepthDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepth instance) => new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepthDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepth(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepthDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The maximum depth for a field, which is measured as the number of inner objects. For instance, if all fields are defined
	/// at the root object level, then the depth is 1. If there is one object mapping, then the depth is 2, etc.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepthDescriptor Limit(long? value)
	{
		Instance.Limit = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepth Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepthDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepth(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepthDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepth(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}