// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

/// <summary>
/// <para>
/// Mapping Limit Settings
/// </para>
/// <para><see href="https://www.elastic.co/docs/reference/elasticsearch/index-settings/mapping-limit">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.MappingLimitSettingsConverter))]
public sealed partial class MappingLimitSettings
{
#if NET7_0_OR_GREATER
	public MappingLimitSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public MappingLimitSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal MappingLimitSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public bool? Coerce { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepth? Depth { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDimensionFields? DimensionFields { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsFieldNameLength? FieldNameLength { get; set; }
	public Elastic.Clients.Elasticsearch.Union<bool, string>? IgnoreMalformed { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFields? NestedFields { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjects? NestedObjects { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsSourceFields? Source { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFields? TotalFields { get; set; }
}

/// <summary>
/// <para>
/// Mapping Limit Settings
/// </para>
/// <para><see href="https://www.elastic.co/docs/reference/elasticsearch/index-settings/mapping-limit">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
public readonly partial struct MappingLimitSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MappingLimitSettingsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public MappingLimitSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings instance) => new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor Coerce(bool? value = true)
	{
		Instance.Coerce = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor Depth(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepth? value)
	{
		Instance.Depth = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor Depth()
	{
		Instance.Depth = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepthDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor Depth(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepthDescriptor>? action)
	{
		Instance.Depth = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDepthDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor DimensionFields(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDimensionFields? value)
	{
		Instance.DimensionFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor DimensionFields()
	{
		Instance.DimensionFields = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDimensionFieldsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor DimensionFields(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDimensionFieldsDescriptor>? action)
	{
		Instance.DimensionFields = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDimensionFieldsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor FieldNameLength(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsFieldNameLength? value)
	{
		Instance.FieldNameLength = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor FieldNameLength()
	{
		Instance.FieldNameLength = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsFieldNameLengthDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor FieldNameLength(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsFieldNameLengthDescriptor>? action)
	{
		Instance.FieldNameLength = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsFieldNameLengthDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor IgnoreMalformed(Elastic.Clients.Elasticsearch.Union<bool, string>? value)
	{
		Instance.IgnoreMalformed = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor NestedFields(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFields? value)
	{
		Instance.NestedFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor NestedFields()
	{
		Instance.NestedFields = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFieldsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor NestedFields(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFieldsDescriptor>? action)
	{
		Instance.NestedFields = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedFieldsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor NestedObjects(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjects? value)
	{
		Instance.NestedObjects = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor NestedObjects()
	{
		Instance.NestedObjects = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjectsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor NestedObjects(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjectsDescriptor>? action)
	{
		Instance.NestedObjects = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsNestedObjectsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor Source(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsSourceFields? value)
	{
		Instance.Source = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor Source(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsSourceFieldsDescriptor> action)
	{
		Instance.Source = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsSourceFieldsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor TotalFields(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFields? value)
	{
		Instance.TotalFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor TotalFields()
	{
		Instance.TotalFields = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFieldsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor TotalFields(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFieldsDescriptor>? action)
	{
		Instance.TotalFields = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsTotalFieldsDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}