// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class ManagedByConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDatastream = System.Text.Json.JsonEncodedText.Encode("Data stream lifecycle");
	private static readonly System.Text.Json.JsonEncodedText MemberIlm = System.Text.Json.JsonEncodedText.Encode("Index Lifecycle Management");
	private static readonly System.Text.Json.JsonEncodedText MemberUnmanaged = System.Text.Json.JsonEncodedText.Encode("Unmanaged");

	public override Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDatastream))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy.Datastream;
		}

		if (reader.ValueTextEquals(MemberIlm))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy.Ilm;
		}

		if (reader.ValueTextEquals(MemberUnmanaged))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy.Unmanaged;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDatastream.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy.Datastream;
		}

		if (string.Equals(value, MemberIlm.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy.Ilm;
		}

		if (string.Equals(value, MemberUnmanaged.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy.Unmanaged;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy.Datastream:
				writer.WriteStringValue(MemberDatastream);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy.Ilm:
				writer.WriteStringValue(MemberIlm);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy.Unmanaged:
				writer.WriteStringValue(MemberUnmanaged);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}