// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class InvertedIndexConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.InvertedIndex>
{
	private static readonly System.Text.Json.JsonEncodedText PropOffsets = System.Text.Json.JsonEncodedText.Encode("offsets");
	private static readonly System.Text.Json.JsonEncodedText PropPayloads = System.Text.Json.JsonEncodedText.Encode("payloads");
	private static readonly System.Text.Json.JsonEncodedText PropPositions = System.Text.Json.JsonEncodedText.Encode("positions");
	private static readonly System.Text.Json.JsonEncodedText PropPostings = System.Text.Json.JsonEncodedText.Encode("postings");
	private static readonly System.Text.Json.JsonEncodedText PropProximity = System.Text.Json.JsonEncodedText.Encode("proximity");
	private static readonly System.Text.Json.JsonEncodedText PropTermFrequencies = System.Text.Json.JsonEncodedText.Encode("term_frequencies");
	private static readonly System.Text.Json.JsonEncodedText PropTerms = System.Text.Json.JsonEncodedText.Encode("terms");

	public override Elastic.Clients.Elasticsearch.IndexManagement.InvertedIndex Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propOffsets = default;
		LocalJsonValue<int> propPayloads = default;
		LocalJsonValue<int> propPositions = default;
		LocalJsonValue<int> propPostings = default;
		LocalJsonValue<int> propProximity = default;
		LocalJsonValue<int> propTermFrequencies = default;
		LocalJsonValue<int> propTerms = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propOffsets.TryReadProperty(ref reader, options, PropOffsets, null))
			{
				continue;
			}

			if (propPayloads.TryReadProperty(ref reader, options, PropPayloads, null))
			{
				continue;
			}

			if (propPositions.TryReadProperty(ref reader, options, PropPositions, null))
			{
				continue;
			}

			if (propPostings.TryReadProperty(ref reader, options, PropPostings, null))
			{
				continue;
			}

			if (propProximity.TryReadProperty(ref reader, options, PropProximity, null))
			{
				continue;
			}

			if (propTermFrequencies.TryReadProperty(ref reader, options, PropTermFrequencies, null))
			{
				continue;
			}

			if (propTerms.TryReadProperty(ref reader, options, PropTerms, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.InvertedIndex(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Offsets = propOffsets.Value,
			Payloads = propPayloads.Value,
			Positions = propPositions.Value,
			Postings = propPostings.Value,
			Proximity = propProximity.Value,
			TermFrequencies = propTermFrequencies.Value,
			Terms = propTerms.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.InvertedIndex value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropOffsets, value.Offsets, null, null);
		writer.WriteProperty(options, PropPayloads, value.Payloads, null, null);
		writer.WriteProperty(options, PropPositions, value.Positions, null, null);
		writer.WriteProperty(options, PropPostings, value.Postings, null, null);
		writer.WriteProperty(options, PropProximity, value.Proximity, null, null);
		writer.WriteProperty(options, PropTermFrequencies, value.TermFrequencies, null, null);
		writer.WriteProperty(options, PropTerms, value.Terms, null, null);
		writer.WriteEndObject();
	}
}