// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.IndexingSlowlogTresholdsConverter))]
public sealed partial class IndexingSlowlogTresholds
{
#if NET7_0_OR_GREATER
	public IndexingSlowlogTresholds()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IndexingSlowlogTresholds()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexingSlowlogTresholds(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The indexing slow log, similar in functionality to the search slow log. The log file name ends with <c>_index_indexing_slowlog.json</c>.
	/// Log and the thresholds are configured in the same way as the search slowlog.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdLevels? Index { get; set; }
}

public readonly partial struct IndexingSlowlogTresholdsDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholds Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexingSlowlogTresholdsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholds instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexingSlowlogTresholdsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholds(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholdsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholds instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholdsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholds(Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholdsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The indexing slow log, similar in functionality to the search slow log. The log file name ends with <c>_index_indexing_slowlog.json</c>.
	/// Log and the thresholds are configured in the same way as the search slowlog.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholdsDescriptor Index(Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdLevels? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The indexing slow log, similar in functionality to the search slow log. The log file name ends with <c>_index_indexing_slowlog.json</c>.
	/// Log and the thresholds are configured in the same way as the search slowlog.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholdsDescriptor Index()
	{
		Instance.Index = Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdLevelsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The indexing slow log, similar in functionality to the search slow log. The log file name ends with <c>_index_indexing_slowlog.json</c>.
	/// Log and the thresholds are configured in the same way as the search slowlog.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholdsDescriptor Index(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdLevelsDescriptor>? action)
	{
		Instance.Index = Elastic.Clients.Elasticsearch.IndexManagement.SlowlogTresholdLevelsDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholds Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholdsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholds(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholdsDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogTresholds(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}