// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.IndexingPressureMemoryConverter))]
public sealed partial class IndexingPressureMemory
{
#if NET7_0_OR_GREATER
	public IndexingPressureMemory()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IndexingPressureMemory()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexingPressureMemory(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Number of outstanding bytes that may be consumed by indexing requests. When this limit is reached or exceeded,
	/// the node will reject new coordinating and primary operations. When replica operations consume 1.5x this limit,
	/// the node will reject new replica operations. Defaults to 10% of the heap.
	/// </para>
	/// </summary>
	public int? Limit { get; set; }
}

public readonly partial struct IndexingPressureMemoryDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemory Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexingPressureMemoryDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemory instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexingPressureMemoryDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemory(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemoryDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemory instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemoryDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemory(Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemoryDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Number of outstanding bytes that may be consumed by indexing requests. When this limit is reached or exceeded,
	/// the node will reject new coordinating and primary operations. When replica operations consume 1.5x this limit,
	/// the node will reject new replica operations. Defaults to 10% of the heap.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemoryDescriptor Limit(int? value)
	{
		Instance.Limit = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemory Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemoryDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemory(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemoryDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureMemory(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}