// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.IndexUpdateAliasesActionConverter))]
public sealed partial class IndexUpdateAliasesAction
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public IndexUpdateAliasesAction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IndexUpdateAliasesAction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Adds a data stream or index to an alias.
	/// If the alias doesn’t exist, the <c>add</c> action creates it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddAction? Add { get => GetVariant<Elastic.Clients.Elasticsearch.IndexManagement.AddAction>("add"); set => SetVariant("add", value); }

	/// <summary>
	/// <para>
	/// Removes a data stream or index from an alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction? Remove { get => GetVariant<Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction>("remove"); set => SetVariant("remove", value); }

	/// <summary>
	/// <para>
	/// Deletes an index.
	/// You cannot use this action on aliases or data streams.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction? RemoveIndex { get => GetVariant<Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction>("remove_index"); set => SetVariant("remove_index", value); }

	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.IndexManagement.AddAction value) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction { Add = value };
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction value) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction { Remove = value };
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction value) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction { RemoveIndex = value };

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct IndexUpdateAliasesActionDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexUpdateAliasesActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexUpdateAliasesActionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Adds a data stream or index to an alias.
	/// If the alias doesn’t exist, the <c>add</c> action creates it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument> Add(Elastic.Clients.Elasticsearch.IndexManagement.AddAction? value)
	{
		Instance.Add = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Adds a data stream or index to an alias.
	/// If the alias doesn’t exist, the <c>add</c> action creates it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument> Add()
	{
		Instance.Add = Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Adds a data stream or index to an alias.
	/// If the alias doesn’t exist, the <c>add</c> action creates it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument> Add(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument>>? action)
	{
		Instance.Add = Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Removes a data stream or index from an alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument> Remove(Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction? value)
	{
		Instance.Remove = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Removes a data stream or index from an alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument> Remove()
	{
		Instance.Remove = Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Removes a data stream or index from an alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument> Remove(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor>? action)
	{
		Instance.Remove = Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Deletes an index.
	/// You cannot use this action on aliases or data streams.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument> RemoveIndex(Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction? value)
	{
		Instance.RemoveIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Deletes an index.
	/// You cannot use this action on aliases or data streams.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument> RemoveIndex()
	{
		Instance.RemoveIndex = Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Deletes an index.
	/// You cannot use this action on aliases or data streams.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument> RemoveIndex(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor>? action)
	{
		Instance.RemoveIndex = Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct IndexUpdateAliasesActionDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexUpdateAliasesActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexUpdateAliasesActionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Adds a data stream or index to an alias.
	/// If the alias doesn’t exist, the <c>add</c> action creates it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor Add(Elastic.Clients.Elasticsearch.IndexManagement.AddAction? value)
	{
		Instance.Add = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Adds a data stream or index to an alias.
	/// If the alias doesn’t exist, the <c>add</c> action creates it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor Add()
	{
		Instance.Add = Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Adds a data stream or index to an alias.
	/// If the alias doesn’t exist, the <c>add</c> action creates it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor Add(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor>? action)
	{
		Instance.Add = Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Adds a data stream or index to an alias.
	/// If the alias doesn’t exist, the <c>add</c> action creates it.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor Add<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<T>>? action)
	{
		Instance.Add = Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Removes a data stream or index from an alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor Remove(Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction? value)
	{
		Instance.Remove = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Removes a data stream or index from an alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor Remove()
	{
		Instance.Remove = Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Removes a data stream or index from an alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor Remove(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor>? action)
	{
		Instance.Remove = Elastic.Clients.Elasticsearch.IndexManagement.RemoveActionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Deletes an index.
	/// You cannot use this action on aliases or data streams.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor RemoveIndex(Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction? value)
	{
		Instance.RemoveIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Deletes an index.
	/// You cannot use this action on aliases or data streams.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor RemoveIndex()
	{
		Instance.RemoveIndex = Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Deletes an index.
	/// You cannot use this action on aliases or data streams.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor RemoveIndex(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor>? action)
	{
		Instance.RemoveIndex = Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexActionDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesActionDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}