// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class IndexUpdateAliasesActionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction>
{
	private static readonly System.Text.Json.JsonEncodedText VariantAdd = System.Text.Json.JsonEncodedText.Encode("add");
	private static readonly System.Text.Json.JsonEncodedText VariantRemove = System.Text.Json.JsonEncodedText.Encode("remove");
	private static readonly System.Text.Json.JsonEncodedText VariantRemoveIndex = System.Text.Json.JsonEncodedText.Encode("remove_index");

	public override Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		string? variantType = null;
		object? variant = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.ValueTextEquals(VariantAdd))
			{
				variantType = VariantAdd.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.AddAction>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRemove))
			{
				variantType = VariantRemove.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction>(options, null);
				continue;
			}

			if (reader.ValueTextEquals(VariantRemoveIndex))
			{
				variantType = VariantRemoveIndex.Value;
				reader.Read();
				variant = reader.ReadValue<Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction>(options, null);
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			VariantType = variantType,
			Variant = variant
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		switch (value.VariantType)
		{
			case null:
				break;
			case "add":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.IndexManagement.AddAction)value.Variant, null, null);
				break;
			case "remove":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.IndexManagement.RemoveAction)value.Variant, null, null);
				break;
			case "remove_index":
				writer.WriteProperty(options, value.VariantType, (Elastic.Clients.Elasticsearch.IndexManagement.RemoveIndexAction)value.Variant, null, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.VariantType}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.IndexUpdateAliasesAction)}'.");
		}

		writer.WriteEndObject();
	}
}