// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.IndexTemplateConverter))]
public sealed partial class IndexTemplate
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexTemplate(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name> composedOf, Elastic.Clients.Elasticsearch.Names indexPatterns)
	{
		ComposedOf = composedOf;
		IndexPatterns = indexPatterns;
	}
#if NET7_0_OR_GREATER
	public IndexTemplate()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IndexTemplate()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public bool? AllowAutoCreate { get; set; }

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name> ComposedOf { get; set; }

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDataStreamConfiguration? DataStream { get; set; }

	/// <summary>
	/// <para>
	/// Marks this index template as deprecated.
	/// When creating or updating a non-deprecated index template that uses deprecated components,
	/// Elasticsearch will emit a deprecation warning.
	/// </para>
	/// </summary>
	public bool? Deprecated { get; set; }

	/// <summary>
	/// <para>
	/// A list of component template names that are allowed to be absent.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Names? IgnoreMissingComponentTemplates { get; set; }

	/// <summary>
	/// <para>
	/// Name of the index template.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Names IndexPatterns { get; set; }

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template. May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Meta { get; set; }

	/// <summary>
	/// <para>
	/// Priority to determine index template precedence when a new data stream or index is created.
	/// The index template with the highest priority is chosen.
	/// If no priority is specified the template is treated as though it is of priority 0 (lowest priority).
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public long? Priority { get; set; }

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummary? Template { get; set; }

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally.
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public long? Version { get; set; }
}

public readonly partial struct IndexTemplateDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexTemplateDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexTemplateDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> AllowAutoCreate(bool? value = true)
	{
		Instance.AllowAutoCreate = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> ComposedOf(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name> value)
	{
		Instance.ComposedOf = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> ComposedOf(params Elastic.Clients.Elasticsearch.Name[] values)
	{
		Instance.ComposedOf = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> DataStream(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDataStreamConfiguration? value)
	{
		Instance.DataStream = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> DataStream()
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDataStreamConfigurationDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> DataStream(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDataStreamConfigurationDescriptor>? action)
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDataStreamConfigurationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Marks this index template as deprecated.
	/// When creating or updating a non-deprecated index template that uses deprecated components,
	/// Elasticsearch will emit a deprecation warning.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> Deprecated(bool? value = true)
	{
		Instance.Deprecated = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of component template names that are allowed to be absent.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> IgnoreMissingComponentTemplates(Elastic.Clients.Elasticsearch.Names? value)
	{
		Instance.IgnoreMissingComponentTemplates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the index template.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> IndexPatterns(Elastic.Clients.Elasticsearch.Names value)
	{
		Instance.IndexPatterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template. May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template. May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template. May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Priority to determine index template precedence when a new data stream or index is created.
	/// The index template with the highest priority is chosen.
	/// If no priority is specified the template is treated as though it is of priority 0 (lowest priority).
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> Priority(long? value)
	{
		Instance.Priority = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> Template(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummary? value)
	{
		Instance.Template = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> Template()
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummaryDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> Template(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummaryDescriptor<TDocument>>? action)
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummaryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally.
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument> Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct IndexTemplateDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexTemplateDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexTemplateDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor AllowAutoCreate(bool? value = true)
	{
		Instance.AllowAutoCreate = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor ComposedOf(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Name> value)
	{
		Instance.ComposedOf = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An ordered list of component template names.
	/// Component templates are merged in the order specified, meaning that the last component template specified has the highest precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor ComposedOf(params Elastic.Clients.Elasticsearch.Name[] values)
	{
		Instance.ComposedOf = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor DataStream(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDataStreamConfiguration? value)
	{
		Instance.DataStream = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor DataStream()
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDataStreamConfigurationDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If this object is included, the template is used to create data streams and their backing indices.
	/// Supports an empty object.
	/// Data streams require a matching index template with a <c>data_stream</c> object.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor DataStream(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDataStreamConfigurationDescriptor>? action)
	{
		Instance.DataStream = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDataStreamConfigurationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Marks this index template as deprecated.
	/// When creating or updating a non-deprecated index template that uses deprecated components,
	/// Elasticsearch will emit a deprecation warning.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor Deprecated(bool? value = true)
	{
		Instance.Deprecated = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of component template names that are allowed to be absent.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor IgnoreMissingComponentTemplates(Elastic.Clients.Elasticsearch.Names? value)
	{
		Instance.IgnoreMissingComponentTemplates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Name of the index template.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor IndexPatterns(Elastic.Clients.Elasticsearch.Names value)
	{
		Instance.IndexPatterns = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template. May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor Meta(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Meta = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template. May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor Meta()
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional user metadata about the index template. May have any contents.
	/// This map is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor Meta(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Meta = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor AddMeta(string key, object value)
	{
		Instance.Meta ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Meta.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Priority to determine index template precedence when a new data stream or index is created.
	/// The index template with the highest priority is chosen.
	/// If no priority is specified the template is treated as though it is of priority 0 (lowest priority).
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor Priority(long? value)
	{
		Instance.Priority = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor Template(Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummary? value)
	{
		Instance.Template = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor Template()
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummaryDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor Template(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummaryDescriptor>? action)
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummaryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Template to be applied.
	/// It may optionally include an <c>aliases</c>, <c>mappings</c>, or <c>settings</c> configuration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor Template<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummaryDescriptor<T>>? action)
	{
		Instance.Template = Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateSummaryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Version number used to manage index templates externally.
	/// This number is not automatically generated by Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor Version(long? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}