// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.IndexSettingsLifecycleStepConverter))]
public sealed partial class IndexSettingsLifecycleStep
{
#if NET7_0_OR_GREATER
	public IndexSettingsLifecycleStep()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IndexSettingsLifecycleStep()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexSettingsLifecycleStep(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Time to wait for the cluster to resolve allocation issues during an ILM shrink action. Must be greater than 1h (1 hour).
	/// See Shard allocation for shrink.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? WaitTimeThreshold { get; set; }
}

public readonly partial struct IndexSettingsLifecycleStepDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStep Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexSettingsLifecycleStepDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStep instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexSettingsLifecycleStepDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStep(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStepDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStep instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStepDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStep(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStepDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Time to wait for the cluster to resolve allocation issues during an ILM shrink action. Must be greater than 1h (1 hour).
	/// See Shard allocation for shrink.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStepDescriptor WaitTimeThreshold(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.WaitTimeThreshold = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStep Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStepDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStep(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStepDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleStep(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}