// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class IndexSettingsAnalysisConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysis>
{
	private static readonly System.Text.Json.JsonEncodedText PropAnalyzers = System.Text.Json.JsonEncodedText.Encode("analyzer");
	private static readonly System.Text.Json.JsonEncodedText PropCharFilters = System.Text.Json.JsonEncodedText.Encode("char_filter");
	private static readonly System.Text.Json.JsonEncodedText PropNormalizers = System.Text.Json.JsonEncodedText.Encode("normalizer");
	private static readonly System.Text.Json.JsonEncodedText PropTokenFilters = System.Text.Json.JsonEncodedText.Encode("filter");
	private static readonly System.Text.Json.JsonEncodedText PropTokenizers = System.Text.Json.JsonEncodedText.Encode("tokenizer");

	public override Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysis Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Analysis.Analyzers?> propAnalyzers = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Analysis.CharFilters?> propCharFilters = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Analysis.Normalizers?> propNormalizers = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Analysis.TokenFilters?> propTokenFilters = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Analysis.Tokenizers?> propTokenizers = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAnalyzers.TryReadProperty(ref reader, options, PropAnalyzers, null))
			{
				continue;
			}

			if (propCharFilters.TryReadProperty(ref reader, options, PropCharFilters, null))
			{
				continue;
			}

			if (propNormalizers.TryReadProperty(ref reader, options, PropNormalizers, null))
			{
				continue;
			}

			if (propTokenFilters.TryReadProperty(ref reader, options, PropTokenFilters, null))
			{
				continue;
			}

			if (propTokenizers.TryReadProperty(ref reader, options, PropTokenizers, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysis(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Analyzers = propAnalyzers.Value,
			CharFilters = propCharFilters.Value,
			Normalizers = propNormalizers.Value,
			TokenFilters = propTokenFilters.Value,
			Tokenizers = propTokenizers.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysis value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAnalyzers, value.Analyzers, null, null);
		writer.WriteProperty(options, PropCharFilters, value.CharFilters, null, null);
		writer.WriteProperty(options, PropNormalizers, value.Normalizers, null, null);
		writer.WriteProperty(options, PropTokenFilters, value.TokenFilters, null, null);
		writer.WriteProperty(options, PropTokenizers, value.Tokenizers, null, null);
		writer.WriteEndObject();
	}
}