// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

/// <summary>
/// <para><see href="https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.IndexSettingsConverter))]
public sealed partial class IndexSettings
{
#if NET7_0_OR_GREATER
	public IndexSettings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IndexSettings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysis? Analysis { get; set; }

	/// <summary>
	/// <para>
	/// Settings to define analyzers, tokenizers, token filters and character filters.
	/// Refer to the linked documentation for step-by-step examples of updating analyzers on existing indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsAnalyze? Analyze { get; set; }
	public string? AutoExpandReplicas { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingBlocks? Blocks { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexCheckOnStartup? CheckOnStartup { get; set; }
	public string? Codec { get; set; }
	public System.DateTimeOffset? CreationDate { get; set; }
	public System.DateTimeOffset? CreationDateString { get; set; }
	public string? DefaultPipeline { get; set; }
	public string? FinalPipeline { get; set; }
	public Elastic.Clients.Elasticsearch.Union<string, int>? Format { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? GcDeletes { get; set; }
	public Elastic.Clients.Elasticsearch.Union<bool, string>? Hidden { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsHighlight? Highlight { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? Index { get; set; }

	/// <summary>
	/// <para>
	/// Configure indexing back pressure limits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressure? IndexingPressure { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogSettings? IndexingSlowlog { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycle? Lifecycle { get; set; }
	public bool? LoadFixedBitsetFiltersEagerly { get; set; }

	/// <summary>
	/// <para>
	/// Enable or disable dynamic mapping for an index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings? Mapping { get; set; }
	public int? MaxDocvalueFieldsSearch { get; set; }
	public int? MaxInnerResultWindow { get; set; }
	public int? MaxNgramDiff { get; set; }
	public int? MaxRefreshListeners { get; set; }
	public int? MaxRegexLength { get; set; }
	public int? MaxRescoreWindow { get; set; }
	public int? MaxResultWindow { get; set; }
	public int? MaxScriptFields { get; set; }
	public int? MaxShingleDiff { get; set; }
	public int? MaxSlicesPerScroll { get; set; }
	public int? MaxTermsCount { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.Merge? Merge { get; set; }
	public string? Mode { get; set; }
	public Elastic.Clients.Elasticsearch.Union<int, string>? NumberOfReplicas { get; set; }
	public int? NumberOfRoutingShards { get; set; }
	public Elastic.Clients.Elasticsearch.Union<int, string>? NumberOfShards { get; set; }

	/// <summary>
	/// <para>
	/// Additional settings not covered in this type.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? OtherSettings { get; set; }
	public Elastic.Clients.Elasticsearch.Union<int, string>? Priority { get; set; }
	public Elastic.Clients.Elasticsearch.Name? ProvidedName { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.Queries? Queries { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsQueryString? QueryString { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? RefreshInterval { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting? Routing { get; set; }
	public int? RoutingPartitionSize { get; set; }
	public System.Collections.Generic.ICollection<string>? RoutingPath { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch? Search { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? Settings { get; set; }

	/// <summary>
	/// <para>
	/// Configure custom similarity settings to customize how search results are scored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarities? Similarity { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes? SoftDeletes { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSort? Sort { get; set; }

	/// <summary>
	/// <para>
	/// The store module allows you to control how index data is stored and accessed on disk.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.Storage? Store { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsTimeSeries? TimeSeries { get; set; }
	public int? TopMetricsMaxSize { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.Translog? Translog { get; set; }
	public string? Uuid { get; set; }
	public Elastic.Clients.Elasticsearch.Union<bool, string>? VerifiedBeforeClose { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexVersioning? Version { get; set; }
}

/// <summary>
/// <para><see href="https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
public readonly partial struct IndexSettingsDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexSettingsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Analysis(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysis? value)
	{
		Instance.Analysis = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Analysis()
	{
		Instance.Analysis = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysisDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Analysis(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysisDescriptor>? action)
	{
		Instance.Analysis = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysisDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to define analyzers, tokenizers, token filters and character filters.
	/// Refer to the linked documentation for step-by-step examples of updating analyzers on existing indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Analyze(Elastic.Clients.Elasticsearch.IndexManagement.SettingsAnalyze? value)
	{
		Instance.Analyze = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to define analyzers, tokenizers, token filters and character filters.
	/// Refer to the linked documentation for step-by-step examples of updating analyzers on existing indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Analyze()
	{
		Instance.Analyze = Elastic.Clients.Elasticsearch.IndexManagement.SettingsAnalyzeDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to define analyzers, tokenizers, token filters and character filters.
	/// Refer to the linked documentation for step-by-step examples of updating analyzers on existing indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Analyze(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsAnalyzeDescriptor>? action)
	{
		Instance.Analyze = Elastic.Clients.Elasticsearch.IndexManagement.SettingsAnalyzeDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> AutoExpandReplicas(string? value)
	{
		Instance.AutoExpandReplicas = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Blocks(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingBlocks? value)
	{
		Instance.Blocks = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Blocks()
	{
		Instance.Blocks = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingBlocksDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Blocks(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingBlocksDescriptor>? action)
	{
		Instance.Blocks = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingBlocksDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> CheckOnStartup(Elastic.Clients.Elasticsearch.IndexManagement.IndexCheckOnStartup? value)
	{
		Instance.CheckOnStartup = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Codec(string? value)
	{
		Instance.Codec = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> CreationDate(System.DateTimeOffset? value)
	{
		Instance.CreationDate = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> CreationDateString(System.DateTimeOffset? value)
	{
		Instance.CreationDateString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> DefaultPipeline(string? value)
	{
		Instance.DefaultPipeline = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> FinalPipeline(string? value)
	{
		Instance.FinalPipeline = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Format(Elastic.Clients.Elasticsearch.Union<string, int>? value)
	{
		Instance.Format = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> GcDeletes(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.GcDeletes = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Hidden(Elastic.Clients.Elasticsearch.Union<bool, string>? value)
	{
		Instance.Hidden = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Highlight(Elastic.Clients.Elasticsearch.IndexManagement.SettingsHighlight? value)
	{
		Instance.Highlight = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Highlight()
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.IndexManagement.SettingsHighlightDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Highlight(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsHighlightDescriptor>? action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.IndexManagement.SettingsHighlightDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? value)
	{
		Instance.Index = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Index()
	{
		Instance.Index = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Index(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>>? action)
	{
		Instance.Index = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configure indexing back pressure limits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> IndexingPressure(Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressure? value)
	{
		Instance.IndexingPressure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configure indexing back pressure limits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> IndexingPressure(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureDescriptor> action)
	{
		Instance.IndexingPressure = Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> IndexingSlowlog(Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogSettings? value)
	{
		Instance.IndexingSlowlog = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> IndexingSlowlog()
	{
		Instance.IndexingSlowlog = Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogSettingsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> IndexingSlowlog(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogSettingsDescriptor>? action)
	{
		Instance.IndexingSlowlog = Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogSettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Lifecycle(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycle? value)
	{
		Instance.Lifecycle = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Lifecycle()
	{
		Instance.Lifecycle = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Lifecycle(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleDescriptor>? action)
	{
		Instance.Lifecycle = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> LoadFixedBitsetFiltersEagerly(bool? value = true)
	{
		Instance.LoadFixedBitsetFiltersEagerly = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enable or disable dynamic mapping for an index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Mapping(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings? value)
	{
		Instance.Mapping = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enable or disable dynamic mapping for an index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Mapping()
	{
		Instance.Mapping = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Enable or disable dynamic mapping for an index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Mapping(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor>? action)
	{
		Instance.Mapping = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxDocvalueFieldsSearch(int? value)
	{
		Instance.MaxDocvalueFieldsSearch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxInnerResultWindow(int? value)
	{
		Instance.MaxInnerResultWindow = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxNgramDiff(int? value)
	{
		Instance.MaxNgramDiff = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxRefreshListeners(int? value)
	{
		Instance.MaxRefreshListeners = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxRegexLength(int? value)
	{
		Instance.MaxRegexLength = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxRescoreWindow(int? value)
	{
		Instance.MaxRescoreWindow = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxResultWindow(int? value)
	{
		Instance.MaxResultWindow = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxScriptFields(int? value)
	{
		Instance.MaxScriptFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxShingleDiff(int? value)
	{
		Instance.MaxShingleDiff = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxSlicesPerScroll(int? value)
	{
		Instance.MaxSlicesPerScroll = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> MaxTermsCount(int? value)
	{
		Instance.MaxTermsCount = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Merge(Elastic.Clients.Elasticsearch.IndexManagement.Merge? value)
	{
		Instance.Merge = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Merge()
	{
		Instance.Merge = Elastic.Clients.Elasticsearch.IndexManagement.MergeDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Merge(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MergeDescriptor>? action)
	{
		Instance.Merge = Elastic.Clients.Elasticsearch.IndexManagement.MergeDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Mode(string? value)
	{
		Instance.Mode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> NumberOfReplicas(Elastic.Clients.Elasticsearch.Union<int, string>? value)
	{
		Instance.NumberOfReplicas = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> NumberOfRoutingShards(int? value)
	{
		Instance.NumberOfRoutingShards = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> NumberOfShards(Elastic.Clients.Elasticsearch.Union<int, string>? value)
	{
		Instance.NumberOfShards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional settings not covered in this type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> OtherSettings(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.OtherSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional settings not covered in this type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> OtherSettings()
	{
		Instance.OtherSettings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional settings not covered in this type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> OtherSettings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.OtherSettings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> AddOtherSetting(string key, object value)
	{
		Instance.OtherSettings ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.OtherSettings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Priority(Elastic.Clients.Elasticsearch.Union<int, string>? value)
	{
		Instance.Priority = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> ProvidedName(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.ProvidedName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Queries(Elastic.Clients.Elasticsearch.IndexManagement.Queries? value)
	{
		Instance.Queries = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Queries()
	{
		Instance.Queries = Elastic.Clients.Elasticsearch.IndexManagement.QueriesDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Queries(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.QueriesDescriptor>? action)
	{
		Instance.Queries = Elastic.Clients.Elasticsearch.IndexManagement.QueriesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> QueryString(Elastic.Clients.Elasticsearch.IndexManagement.SettingsQueryString? value)
	{
		Instance.QueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> QueryString(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsQueryStringDescriptor> action)
	{
		Instance.QueryString = Elastic.Clients.Elasticsearch.IndexManagement.SettingsQueryStringDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> RefreshInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.RefreshInterval = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting? value)
	{
		Instance.Routing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Routing()
	{
		Instance.Routing = Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Routing(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor>? action)
	{
		Instance.Routing = Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> RoutingPartitionSize(int? value)
	{
		Instance.RoutingPartitionSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> RoutingPath(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.RoutingPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> RoutingPath(params string[] values)
	{
		Instance.RoutingPath = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Search(Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch? value)
	{
		Instance.Search = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Search()
	{
		Instance.Search = Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Search(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor>? action)
	{
		Instance.Search = Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Settings(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? value)
	{
		Instance.Settings = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Settings(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configure custom similarity settings to customize how search results are scored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Similarity(Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarities? value)
	{
		Instance.Similarity = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configure custom similarity settings to customize how search results are scored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Similarity(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor> action)
	{
		Instance.Similarity = Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> SoftDeletes(Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes? value)
	{
		Instance.SoftDeletes = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> SoftDeletes()
	{
		Instance.SoftDeletes = Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> SoftDeletes(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor>? action)
	{
		Instance.SoftDeletes = Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Sort(Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSort? value)
	{
		Instance.Sort = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Sort()
	{
		Instance.Sort = Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSortDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Sort(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSortDescriptor<TDocument>>? action)
	{
		Instance.Sort = Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSortDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The store module allows you to control how index data is stored and accessed on disk.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Store(Elastic.Clients.Elasticsearch.IndexManagement.Storage? value)
	{
		Instance.Store = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The store module allows you to control how index data is stored and accessed on disk.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Store(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor> action)
	{
		Instance.Store = Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> TimeSeries(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsTimeSeries? value)
	{
		Instance.TimeSeries = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> TimeSeries()
	{
		Instance.TimeSeries = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsTimeSeriesDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> TimeSeries(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsTimeSeriesDescriptor>? action)
	{
		Instance.TimeSeries = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsTimeSeriesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> TopMetricsMaxSize(int? value)
	{
		Instance.TopMetricsMaxSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Translog(Elastic.Clients.Elasticsearch.IndexManagement.Translog? value)
	{
		Instance.Translog = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Translog()
	{
		Instance.Translog = Elastic.Clients.Elasticsearch.IndexManagement.TranslogDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Translog(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.TranslogDescriptor>? action)
	{
		Instance.Translog = Elastic.Clients.Elasticsearch.IndexManagement.TranslogDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Uuid(string? value)
	{
		Instance.Uuid = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> VerifiedBeforeClose(Elastic.Clients.Elasticsearch.Union<bool, string>? value)
	{
		Instance.VerifiedBeforeClose = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Version(Elastic.Clients.Elasticsearch.IndexManagement.IndexVersioning? value)
	{
		Instance.Version = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Version()
	{
		Instance.Version = Elastic.Clients.Elasticsearch.IndexManagement.IndexVersioningDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument> Version(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexVersioningDescriptor>? action)
	{
		Instance.Version = Elastic.Clients.Elasticsearch.IndexManagement.IndexVersioningDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

/// <summary>
/// <para><see href="https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules">Learn more about this API in the Elasticsearch documentation.</see></para>
/// </summary>
public readonly partial struct IndexSettingsDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexSettingsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexSettingsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Analysis(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysis? value)
	{
		Instance.Analysis = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Analysis()
	{
		Instance.Analysis = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysisDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Analysis(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysisDescriptor>? action)
	{
		Instance.Analysis = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysisDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to define analyzers, tokenizers, token filters and character filters.
	/// Refer to the linked documentation for step-by-step examples of updating analyzers on existing indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Analyze(Elastic.Clients.Elasticsearch.IndexManagement.SettingsAnalyze? value)
	{
		Instance.Analyze = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to define analyzers, tokenizers, token filters and character filters.
	/// Refer to the linked documentation for step-by-step examples of updating analyzers on existing indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Analyze()
	{
		Instance.Analyze = Elastic.Clients.Elasticsearch.IndexManagement.SettingsAnalyzeDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings to define analyzers, tokenizers, token filters and character filters.
	/// Refer to the linked documentation for step-by-step examples of updating analyzers on existing indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Analyze(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsAnalyzeDescriptor>? action)
	{
		Instance.Analyze = Elastic.Clients.Elasticsearch.IndexManagement.SettingsAnalyzeDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor AutoExpandReplicas(string? value)
	{
		Instance.AutoExpandReplicas = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Blocks(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingBlocks? value)
	{
		Instance.Blocks = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Blocks()
	{
		Instance.Blocks = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingBlocksDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Blocks(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingBlocksDescriptor>? action)
	{
		Instance.Blocks = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingBlocksDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor CheckOnStartup(Elastic.Clients.Elasticsearch.IndexManagement.IndexCheckOnStartup? value)
	{
		Instance.CheckOnStartup = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Codec(string? value)
	{
		Instance.Codec = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor CreationDate(System.DateTimeOffset? value)
	{
		Instance.CreationDate = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor CreationDateString(System.DateTimeOffset? value)
	{
		Instance.CreationDateString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor DefaultPipeline(string? value)
	{
		Instance.DefaultPipeline = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor FinalPipeline(string? value)
	{
		Instance.FinalPipeline = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Format(Elastic.Clients.Elasticsearch.Union<string, int>? value)
	{
		Instance.Format = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor GcDeletes(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.GcDeletes = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Hidden(Elastic.Clients.Elasticsearch.Union<bool, string>? value)
	{
		Instance.Hidden = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Highlight(Elastic.Clients.Elasticsearch.IndexManagement.SettingsHighlight? value)
	{
		Instance.Highlight = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Highlight()
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.IndexManagement.SettingsHighlightDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Highlight(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsHighlightDescriptor>? action)
	{
		Instance.Highlight = Elastic.Clients.Elasticsearch.IndexManagement.SettingsHighlightDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Index(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? value)
	{
		Instance.Index = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Index()
	{
		Instance.Index = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Index(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor>? action)
	{
		Instance.Index = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Index<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<T>>? action)
	{
		Instance.Index = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configure indexing back pressure limits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor IndexingPressure(Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressure? value)
	{
		Instance.IndexingPressure = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configure indexing back pressure limits.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor IndexingPressure(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureDescriptor> action)
	{
		Instance.IndexingPressure = Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressureDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor IndexingSlowlog(Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogSettings? value)
	{
		Instance.IndexingSlowlog = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor IndexingSlowlog()
	{
		Instance.IndexingSlowlog = Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogSettingsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor IndexingSlowlog(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogSettingsDescriptor>? action)
	{
		Instance.IndexingSlowlog = Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogSettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Lifecycle(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycle? value)
	{
		Instance.Lifecycle = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Lifecycle()
	{
		Instance.Lifecycle = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Lifecycle(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleDescriptor>? action)
	{
		Instance.Lifecycle = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycleDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor LoadFixedBitsetFiltersEagerly(bool? value = true)
	{
		Instance.LoadFixedBitsetFiltersEagerly = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enable or disable dynamic mapping for an index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Mapping(Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings? value)
	{
		Instance.Mapping = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Enable or disable dynamic mapping for an index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Mapping()
	{
		Instance.Mapping = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Enable or disable dynamic mapping for an index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Mapping(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor>? action)
	{
		Instance.Mapping = Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxDocvalueFieldsSearch(int? value)
	{
		Instance.MaxDocvalueFieldsSearch = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxInnerResultWindow(int? value)
	{
		Instance.MaxInnerResultWindow = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxNgramDiff(int? value)
	{
		Instance.MaxNgramDiff = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxRefreshListeners(int? value)
	{
		Instance.MaxRefreshListeners = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxRegexLength(int? value)
	{
		Instance.MaxRegexLength = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxRescoreWindow(int? value)
	{
		Instance.MaxRescoreWindow = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxResultWindow(int? value)
	{
		Instance.MaxResultWindow = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxScriptFields(int? value)
	{
		Instance.MaxScriptFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxShingleDiff(int? value)
	{
		Instance.MaxShingleDiff = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxSlicesPerScroll(int? value)
	{
		Instance.MaxSlicesPerScroll = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor MaxTermsCount(int? value)
	{
		Instance.MaxTermsCount = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Merge(Elastic.Clients.Elasticsearch.IndexManagement.Merge? value)
	{
		Instance.Merge = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Merge()
	{
		Instance.Merge = Elastic.Clients.Elasticsearch.IndexManagement.MergeDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Merge(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.MergeDescriptor>? action)
	{
		Instance.Merge = Elastic.Clients.Elasticsearch.IndexManagement.MergeDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Mode(string? value)
	{
		Instance.Mode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor NumberOfReplicas(Elastic.Clients.Elasticsearch.Union<int, string>? value)
	{
		Instance.NumberOfReplicas = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor NumberOfRoutingShards(int? value)
	{
		Instance.NumberOfRoutingShards = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor NumberOfShards(Elastic.Clients.Elasticsearch.Union<int, string>? value)
	{
		Instance.NumberOfShards = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional settings not covered in this type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor OtherSettings(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.OtherSettings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional settings not covered in this type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor OtherSettings()
	{
		Instance.OtherSettings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional settings not covered in this type.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor OtherSettings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.OtherSettings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor AddOtherSetting(string key, object value)
	{
		Instance.OtherSettings ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.OtherSettings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Priority(Elastic.Clients.Elasticsearch.Union<int, string>? value)
	{
		Instance.Priority = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor ProvidedName(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.ProvidedName = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Queries(Elastic.Clients.Elasticsearch.IndexManagement.Queries? value)
	{
		Instance.Queries = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Queries()
	{
		Instance.Queries = Elastic.Clients.Elasticsearch.IndexManagement.QueriesDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Queries(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.QueriesDescriptor>? action)
	{
		Instance.Queries = Elastic.Clients.Elasticsearch.IndexManagement.QueriesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor QueryString(Elastic.Clients.Elasticsearch.IndexManagement.SettingsQueryString? value)
	{
		Instance.QueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor QueryString(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsQueryStringDescriptor> action)
	{
		Instance.QueryString = Elastic.Clients.Elasticsearch.IndexManagement.SettingsQueryStringDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor RefreshInterval(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.RefreshInterval = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Routing(Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting? value)
	{
		Instance.Routing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Routing()
	{
		Instance.Routing = Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Routing(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor>? action)
	{
		Instance.Routing = Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor RoutingPartitionSize(int? value)
	{
		Instance.RoutingPartitionSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor RoutingPath(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.RoutingPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor RoutingPath(params string[] values)
	{
		Instance.RoutingPath = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Search(Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch? value)
	{
		Instance.Search = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Search()
	{
		Instance.Search = Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Search(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor>? action)
	{
		Instance.Search = Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearchDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Settings(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings? value)
	{
		Instance.Settings = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Settings()
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Settings(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Settings<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<T>>? action)
	{
		Instance.Settings = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configure custom similarity settings to customize how search results are scored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Similarity(Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarities? value)
	{
		Instance.Similarity = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configure custom similarity settings to customize how search results are scored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Similarity(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor> action)
	{
		Instance.Similarity = Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilaritiesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor SoftDeletes(Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes? value)
	{
		Instance.SoftDeletes = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor SoftDeletes()
	{
		Instance.SoftDeletes = Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor SoftDeletes(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor>? action)
	{
		Instance.SoftDeletes = Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Sort(Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSort? value)
	{
		Instance.Sort = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Sort()
	{
		Instance.Sort = Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSortDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Sort(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSortDescriptor>? action)
	{
		Instance.Sort = Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSortDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Sort<T>(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSortDescriptor<T>>? action)
	{
		Instance.Sort = Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSortDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The store module allows you to control how index data is stored and accessed on disk.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Store(Elastic.Clients.Elasticsearch.IndexManagement.Storage? value)
	{
		Instance.Store = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The store module allows you to control how index data is stored and accessed on disk.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Store(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor> action)
	{
		Instance.Store = Elastic.Clients.Elasticsearch.IndexManagement.StorageDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor TimeSeries(Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsTimeSeries? value)
	{
		Instance.TimeSeries = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor TimeSeries()
	{
		Instance.TimeSeries = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsTimeSeriesDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor TimeSeries(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsTimeSeriesDescriptor>? action)
	{
		Instance.TimeSeries = Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsTimeSeriesDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor TopMetricsMaxSize(int? value)
	{
		Instance.TopMetricsMaxSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Translog(Elastic.Clients.Elasticsearch.IndexManagement.Translog? value)
	{
		Instance.Translog = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Translog()
	{
		Instance.Translog = Elastic.Clients.Elasticsearch.IndexManagement.TranslogDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Translog(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.TranslogDescriptor>? action)
	{
		Instance.Translog = Elastic.Clients.Elasticsearch.IndexManagement.TranslogDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Uuid(string? value)
	{
		Instance.Uuid = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor VerifiedBeforeClose(Elastic.Clients.Elasticsearch.Union<bool, string>? value)
	{
		Instance.VerifiedBeforeClose = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Version(Elastic.Clients.Elasticsearch.IndexManagement.IndexVersioning? value)
	{
		Instance.Version = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Version()
	{
		Instance.Version = Elastic.Clients.Elasticsearch.IndexManagement.IndexVersioningDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor Version(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexVersioningDescriptor>? action)
	{
		Instance.Version = Elastic.Clients.Elasticsearch.IndexManagement.IndexVersioningDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}