// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class IndexSettingsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings>
{
	private static readonly System.Text.Json.JsonEncodedText PropAnalysis = System.Text.Json.JsonEncodedText.Encode("analysis");
	private static readonly System.Text.Json.JsonEncodedText PropAnalyze = System.Text.Json.JsonEncodedText.Encode("analyze");
	private static readonly System.Text.Json.JsonEncodedText PropAutoExpandReplicas = System.Text.Json.JsonEncodedText.Encode("auto_expand_replicas");
	private static readonly System.Text.Json.JsonEncodedText PropBlocks = System.Text.Json.JsonEncodedText.Encode("blocks");
	private static readonly System.Text.Json.JsonEncodedText PropCheckOnStartup = System.Text.Json.JsonEncodedText.Encode("check_on_startup");
	private static readonly System.Text.Json.JsonEncodedText PropCodec = System.Text.Json.JsonEncodedText.Encode("codec");
	private static readonly System.Text.Json.JsonEncodedText PropCreationDate = System.Text.Json.JsonEncodedText.Encode("creation_date");
	private static readonly System.Text.Json.JsonEncodedText PropCreationDateString = System.Text.Json.JsonEncodedText.Encode("creation_date_string");
	private static readonly System.Text.Json.JsonEncodedText PropDefaultPipeline = System.Text.Json.JsonEncodedText.Encode("default_pipeline");
	private static readonly System.Text.Json.JsonEncodedText PropFinalPipeline = System.Text.Json.JsonEncodedText.Encode("final_pipeline");
	private static readonly System.Text.Json.JsonEncodedText PropFormat = System.Text.Json.JsonEncodedText.Encode("format");
	private static readonly System.Text.Json.JsonEncodedText PropGcDeletes = System.Text.Json.JsonEncodedText.Encode("gc_deletes");
	private static readonly System.Text.Json.JsonEncodedText PropHidden = System.Text.Json.JsonEncodedText.Encode("hidden");
	private static readonly System.Text.Json.JsonEncodedText PropHighlight = System.Text.Json.JsonEncodedText.Encode("highlight");
	private static readonly System.Text.Json.JsonEncodedText PropIndex = System.Text.Json.JsonEncodedText.Encode("index");
	private static readonly System.Text.Json.JsonEncodedText PropIndexingPressure = System.Text.Json.JsonEncodedText.Encode("indexing_pressure");
	private static readonly System.Text.Json.JsonEncodedText PropIndexingSlowlog = System.Text.Json.JsonEncodedText.Encode("indexing.slowlog");
	private static readonly System.Text.Json.JsonEncodedText PropLifecycle = System.Text.Json.JsonEncodedText.Encode("lifecycle");
	private static readonly System.Text.Json.JsonEncodedText PropLoadFixedBitsetFiltersEagerly = System.Text.Json.JsonEncodedText.Encode("load_fixed_bitset_filters_eagerly");
	private static readonly System.Text.Json.JsonEncodedText PropMapping = System.Text.Json.JsonEncodedText.Encode("mapping");
	private static readonly System.Text.Json.JsonEncodedText PropMaxDocvalueFieldsSearch = System.Text.Json.JsonEncodedText.Encode("max_docvalue_fields_search");
	private static readonly System.Text.Json.JsonEncodedText PropMaxInnerResultWindow = System.Text.Json.JsonEncodedText.Encode("max_inner_result_window");
	private static readonly System.Text.Json.JsonEncodedText PropMaxNgramDiff = System.Text.Json.JsonEncodedText.Encode("max_ngram_diff");
	private static readonly System.Text.Json.JsonEncodedText PropMaxRefreshListeners = System.Text.Json.JsonEncodedText.Encode("max_refresh_listeners");
	private static readonly System.Text.Json.JsonEncodedText PropMaxRegexLength = System.Text.Json.JsonEncodedText.Encode("max_regex_length");
	private static readonly System.Text.Json.JsonEncodedText PropMaxRescoreWindow = System.Text.Json.JsonEncodedText.Encode("max_rescore_window");
	private static readonly System.Text.Json.JsonEncodedText PropMaxResultWindow = System.Text.Json.JsonEncodedText.Encode("max_result_window");
	private static readonly System.Text.Json.JsonEncodedText PropMaxScriptFields = System.Text.Json.JsonEncodedText.Encode("max_script_fields");
	private static readonly System.Text.Json.JsonEncodedText PropMaxShingleDiff = System.Text.Json.JsonEncodedText.Encode("max_shingle_diff");
	private static readonly System.Text.Json.JsonEncodedText PropMaxSlicesPerScroll = System.Text.Json.JsonEncodedText.Encode("max_slices_per_scroll");
	private static readonly System.Text.Json.JsonEncodedText PropMaxTermsCount = System.Text.Json.JsonEncodedText.Encode("max_terms_count");
	private static readonly System.Text.Json.JsonEncodedText PropMerge = System.Text.Json.JsonEncodedText.Encode("merge");
	private static readonly System.Text.Json.JsonEncodedText PropMode = System.Text.Json.JsonEncodedText.Encode("mode");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfReplicas = System.Text.Json.JsonEncodedText.Encode("number_of_replicas");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfRoutingShards = System.Text.Json.JsonEncodedText.Encode("number_of_routing_shards");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfShards = System.Text.Json.JsonEncodedText.Encode("number_of_shards");
	private static readonly System.Text.Json.JsonEncodedText PropPriority = System.Text.Json.JsonEncodedText.Encode("priority");
	private static readonly System.Text.Json.JsonEncodedText PropProvidedName = System.Text.Json.JsonEncodedText.Encode("provided_name");
	private static readonly System.Text.Json.JsonEncodedText PropQueries = System.Text.Json.JsonEncodedText.Encode("queries");
	private static readonly System.Text.Json.JsonEncodedText PropQueryString = System.Text.Json.JsonEncodedText.Encode("query_string");
	private static readonly System.Text.Json.JsonEncodedText PropRefreshInterval = System.Text.Json.JsonEncodedText.Encode("refresh_interval");
	private static readonly System.Text.Json.JsonEncodedText PropRouting = System.Text.Json.JsonEncodedText.Encode("routing");
	private static readonly System.Text.Json.JsonEncodedText PropRoutingPartitionSize = System.Text.Json.JsonEncodedText.Encode("routing_partition_size");
	private static readonly System.Text.Json.JsonEncodedText PropRoutingPath = System.Text.Json.JsonEncodedText.Encode("routing_path");
	private static readonly System.Text.Json.JsonEncodedText PropSearch = System.Text.Json.JsonEncodedText.Encode("search");
	private static readonly System.Text.Json.JsonEncodedText PropSettings = System.Text.Json.JsonEncodedText.Encode("settings");
	private static readonly System.Text.Json.JsonEncodedText PropSimilarity = System.Text.Json.JsonEncodedText.Encode("similarity");
	private static readonly System.Text.Json.JsonEncodedText PropSoftDeletes = System.Text.Json.JsonEncodedText.Encode("soft_deletes");
	private static readonly System.Text.Json.JsonEncodedText PropSort = System.Text.Json.JsonEncodedText.Encode("sort");
	private static readonly System.Text.Json.JsonEncodedText PropStore = System.Text.Json.JsonEncodedText.Encode("store");
	private static readonly System.Text.Json.JsonEncodedText PropTimeSeries = System.Text.Json.JsonEncodedText.Encode("time_series");
	private static readonly System.Text.Json.JsonEncodedText PropTopMetricsMaxSize = System.Text.Json.JsonEncodedText.Encode("top_metrics_max_size");
	private static readonly System.Text.Json.JsonEncodedText PropTranslog = System.Text.Json.JsonEncodedText.Encode("translog");
	private static readonly System.Text.Json.JsonEncodedText PropUuid = System.Text.Json.JsonEncodedText.Encode("uuid");
	private static readonly System.Text.Json.JsonEncodedText PropVerifiedBeforeClose = System.Text.Json.JsonEncodedText.Encode("verified_before_close");
	private static readonly System.Text.Json.JsonEncodedText PropVersion = System.Text.Json.JsonEncodedText.Encode("version");

	public override Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsAnalysis?> propAnalysis = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsAnalyze?> propAnalyze = default;
		LocalJsonValue<string?> propAutoExpandReplicas = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingBlocks?> propBlocks = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexCheckOnStartup?> propCheckOnStartup = default;
		LocalJsonValue<string?> propCodec = default;
		LocalJsonValue<System.DateTimeOffset?> propCreationDate = default;
		LocalJsonValue<System.DateTimeOffset?> propCreationDateString = default;
		LocalJsonValue<string?> propDefaultPipeline = default;
		LocalJsonValue<string?> propFinalPipeline = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Union<string, int>?> propFormat = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propGcDeletes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Union<bool, string>?> propHidden = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsHighlight?> propHighlight = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings?> propIndex = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexingPressure?> propIndexingPressure = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexingSlowlogSettings?> propIndexingSlowlog = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsLifecycle?> propLifecycle = default;
		LocalJsonValue<bool?> propLoadFixedBitsetFiltersEagerly = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.MappingLimitSettings?> propMapping = default;
		LocalJsonValue<int?> propMaxDocvalueFieldsSearch = default;
		LocalJsonValue<int?> propMaxInnerResultWindow = default;
		LocalJsonValue<int?> propMaxNgramDiff = default;
		LocalJsonValue<int?> propMaxRefreshListeners = default;
		LocalJsonValue<int?> propMaxRegexLength = default;
		LocalJsonValue<int?> propMaxRescoreWindow = default;
		LocalJsonValue<int?> propMaxResultWindow = default;
		LocalJsonValue<int?> propMaxScriptFields = default;
		LocalJsonValue<int?> propMaxShingleDiff = default;
		LocalJsonValue<int?> propMaxSlicesPerScroll = default;
		LocalJsonValue<int?> propMaxTermsCount = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.Merge?> propMerge = default;
		LocalJsonValue<string?> propMode = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Union<int, string>?> propNumberOfReplicas = default;
		LocalJsonValue<int?> propNumberOfRoutingShards = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Union<int, string>?> propNumberOfShards = default;
		System.Collections.Generic.Dictionary<string, object>? propOtherSettings = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Union<int, string>?> propPriority = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Name?> propProvidedName = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.Queries?> propQueries = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsQueryString?> propQueryString = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propRefreshInterval = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting?> propRouting = default;
		LocalJsonValue<int?> propRoutingPartitionSize = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propRoutingPath = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSearch?> propSearch = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings?> propSettings = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.SettingsSimilarities?> propSimilarity = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.SoftDeletes?> propSoftDeletes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexSegmentSort?> propSort = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.Storage?> propStore = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettingsTimeSeries?> propTimeSeries = default;
		LocalJsonValue<int?> propTopMetricsMaxSize = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.Translog?> propTranslog = default;
		LocalJsonValue<string?> propUuid = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Union<bool, string>?> propVerifiedBeforeClose = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexVersioning?> propVersion = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAnalysis.TryReadProperty(ref reader, options, PropAnalysis, null))
			{
				continue;
			}

			if (propAnalyze.TryReadProperty(ref reader, options, PropAnalyze, null))
			{
				continue;
			}

			if (propAutoExpandReplicas.TryReadProperty(ref reader, options, PropAutoExpandReplicas, null))
			{
				continue;
			}

			if (propBlocks.TryReadProperty(ref reader, options, PropBlocks, null))
			{
				continue;
			}

			if (propCheckOnStartup.TryReadProperty(ref reader, options, PropCheckOnStartup, static Elastic.Clients.Elasticsearch.IndexManagement.IndexCheckOnStartup? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexCheckOnStartup>(o)))
			{
				continue;
			}

			if (propCodec.TryReadProperty(ref reader, options, PropCodec, null))
			{
				continue;
			}

			if (propCreationDate.TryReadProperty(ref reader, options, PropCreationDate, static System.DateTimeOffset? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propCreationDateString.TryReadProperty(ref reader, options, PropCreationDateString, static System.DateTimeOffset? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMarker))))
			{
				continue;
			}

			if (propDefaultPipeline.TryReadProperty(ref reader, options, PropDefaultPipeline, null))
			{
				continue;
			}

			if (propFinalPipeline.TryReadProperty(ref reader, options, PropFinalPipeline, null))
			{
				continue;
			}

			if (propFormat.TryReadProperty(ref reader, options, PropFormat, static Elastic.Clients.Elasticsearch.Union<string, int>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadUnionValue<string, int>(o, static (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => JsonUnionSelector.ByTokenType(ref r, o, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.String, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.Number), null, null)))
			{
				continue;
			}

			if (propGcDeletes.TryReadProperty(ref reader, options, PropGcDeletes, null))
			{
				continue;
			}

			if (propHidden.TryReadProperty(ref reader, options, PropHidden, static Elastic.Clients.Elasticsearch.Union<bool, string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadUnionValue<bool, string>(o, static (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => JsonUnionSelector.ByTokenType(ref r, o, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.True | Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.False, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.String), null, null)))
			{
				continue;
			}

			if (propHighlight.TryReadProperty(ref reader, options, PropHighlight, null))
			{
				continue;
			}

			if (propIndex.TryReadProperty(ref reader, options, PropIndex, null))
			{
				continue;
			}

			if (propIndexingPressure.TryReadProperty(ref reader, options, PropIndexingPressure, null))
			{
				continue;
			}

			if (propIndexingSlowlog.TryReadProperty(ref reader, options, PropIndexingSlowlog, null))
			{
				continue;
			}

			if (propLifecycle.TryReadProperty(ref reader, options, PropLifecycle, null))
			{
				continue;
			}

			if (propLoadFixedBitsetFiltersEagerly.TryReadProperty(ref reader, options, PropLoadFixedBitsetFiltersEagerly, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propMapping.TryReadProperty(ref reader, options, PropMapping, null))
			{
				continue;
			}

			if (propMaxDocvalueFieldsSearch.TryReadProperty(ref reader, options, PropMaxDocvalueFieldsSearch, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxInnerResultWindow.TryReadProperty(ref reader, options, PropMaxInnerResultWindow, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxNgramDiff.TryReadProperty(ref reader, options, PropMaxNgramDiff, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxRefreshListeners.TryReadProperty(ref reader, options, PropMaxRefreshListeners, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxRegexLength.TryReadProperty(ref reader, options, PropMaxRegexLength, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxRescoreWindow.TryReadProperty(ref reader, options, PropMaxRescoreWindow, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxResultWindow.TryReadProperty(ref reader, options, PropMaxResultWindow, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxScriptFields.TryReadProperty(ref reader, options, PropMaxScriptFields, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxShingleDiff.TryReadProperty(ref reader, options, PropMaxShingleDiff, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxSlicesPerScroll.TryReadProperty(ref reader, options, PropMaxSlicesPerScroll, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMaxTermsCount.TryReadProperty(ref reader, options, PropMaxTermsCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propMerge.TryReadProperty(ref reader, options, PropMerge, null))
			{
				continue;
			}

			if (propMode.TryReadProperty(ref reader, options, PropMode, null))
			{
				continue;
			}

			if (propNumberOfReplicas.TryReadProperty(ref reader, options, PropNumberOfReplicas, static Elastic.Clients.Elasticsearch.Union<int, string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadUnionValue<int, string>(o, static (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => JsonUnionSelector.ByTokenType(ref r, o, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.Number, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.String), null, null)))
			{
				continue;
			}

			if (propNumberOfRoutingShards.TryReadProperty(ref reader, options, PropNumberOfRoutingShards, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propNumberOfShards.TryReadProperty(ref reader, options, PropNumberOfShards, static Elastic.Clients.Elasticsearch.Union<int, string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadUnionValue<int, string>(o, static (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => JsonUnionSelector.ByTokenType(ref r, o, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.Number, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.String), null, null)))
			{
				continue;
			}

			if (propPriority.TryReadProperty(ref reader, options, PropPriority, static Elastic.Clients.Elasticsearch.Union<int, string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadUnionValue<int, string>(o, static (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => JsonUnionSelector.ByTokenType(ref r, o, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.Number, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.String), null, null)))
			{
				continue;
			}

			if (propProvidedName.TryReadProperty(ref reader, options, PropProvidedName, null))
			{
				continue;
			}

			if (propQueries.TryReadProperty(ref reader, options, PropQueries, null))
			{
				continue;
			}

			if (propQueryString.TryReadProperty(ref reader, options, PropQueryString, null))
			{
				continue;
			}

			if (propRefreshInterval.TryReadProperty(ref reader, options, PropRefreshInterval, null))
			{
				continue;
			}

			if (propRouting.TryReadProperty(ref reader, options, PropRouting, null))
			{
				continue;
			}

			if (propRoutingPartitionSize.TryReadProperty(ref reader, options, PropRoutingPartitionSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propRoutingPath.TryReadProperty(ref reader, options, PropRoutingPath, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadSingleOrManyCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propSearch.TryReadProperty(ref reader, options, PropSearch, null))
			{
				continue;
			}

			if (propSettings.TryReadProperty(ref reader, options, PropSettings, null))
			{
				continue;
			}

			if (propSimilarity.TryReadProperty(ref reader, options, PropSimilarity, null))
			{
				continue;
			}

			if (propSoftDeletes.TryReadProperty(ref reader, options, PropSoftDeletes, null))
			{
				continue;
			}

			if (propSort.TryReadProperty(ref reader, options, PropSort, null))
			{
				continue;
			}

			if (propStore.TryReadProperty(ref reader, options, PropStore, null))
			{
				continue;
			}

			if (propTimeSeries.TryReadProperty(ref reader, options, PropTimeSeries, null))
			{
				continue;
			}

			if (propTopMetricsMaxSize.TryReadProperty(ref reader, options, PropTopMetricsMaxSize, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propTranslog.TryReadProperty(ref reader, options, PropTranslog, null))
			{
				continue;
			}

			if (propUuid.TryReadProperty(ref reader, options, PropUuid, null))
			{
				continue;
			}

			if (propVerifiedBeforeClose.TryReadProperty(ref reader, options, PropVerifiedBeforeClose, static Elastic.Clients.Elasticsearch.Union<bool, string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadUnionValue<bool, string>(o, static (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => JsonUnionSelector.ByTokenType(ref r, o, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.True | Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.False, Elastic.Clients.Elasticsearch.Serialization.JsonTokenTypes.String), null, null)))
			{
				continue;
			}

			if (propVersion.TryReadProperty(ref reader, options, PropVersion, null))
			{
				continue;
			}

			propOtherSettings ??= new System.Collections.Generic.Dictionary<string, object>();
			reader.ReadProperty(options, out string key, out object value, static string (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadPropertyName<string>(o)!, static object (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<object>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>))!);
			propOtherSettings[key] = value;
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Analysis = propAnalysis.Value,
			Analyze = propAnalyze.Value,
			AutoExpandReplicas = propAutoExpandReplicas.Value,
			Blocks = propBlocks.Value,
			CheckOnStartup = propCheckOnStartup.Value,
			Codec = propCodec.Value,
			CreationDate = propCreationDate.Value,
			CreationDateString = propCreationDateString.Value,
			DefaultPipeline = propDefaultPipeline.Value,
			FinalPipeline = propFinalPipeline.Value,
			Format = propFormat.Value,
			GcDeletes = propGcDeletes.Value,
			Hidden = propHidden.Value,
			Highlight = propHighlight.Value,
			Index = propIndex.Value,
			IndexingPressure = propIndexingPressure.Value,
			IndexingSlowlog = propIndexingSlowlog.Value,
			Lifecycle = propLifecycle.Value,
			LoadFixedBitsetFiltersEagerly = propLoadFixedBitsetFiltersEagerly.Value,
			Mapping = propMapping.Value,
			MaxDocvalueFieldsSearch = propMaxDocvalueFieldsSearch.Value,
			MaxInnerResultWindow = propMaxInnerResultWindow.Value,
			MaxNgramDiff = propMaxNgramDiff.Value,
			MaxRefreshListeners = propMaxRefreshListeners.Value,
			MaxRegexLength = propMaxRegexLength.Value,
			MaxRescoreWindow = propMaxRescoreWindow.Value,
			MaxResultWindow = propMaxResultWindow.Value,
			MaxScriptFields = propMaxScriptFields.Value,
			MaxShingleDiff = propMaxShingleDiff.Value,
			MaxSlicesPerScroll = propMaxSlicesPerScroll.Value,
			MaxTermsCount = propMaxTermsCount.Value,
			Merge = propMerge.Value,
			Mode = propMode.Value,
			NumberOfReplicas = propNumberOfReplicas.Value,
			NumberOfRoutingShards = propNumberOfRoutingShards.Value,
			NumberOfShards = propNumberOfShards.Value,
			OtherSettings = propOtherSettings,
			Priority = propPriority.Value,
			ProvidedName = propProvidedName.Value,
			Queries = propQueries.Value,
			QueryString = propQueryString.Value,
			RefreshInterval = propRefreshInterval.Value,
			Routing = propRouting.Value,
			RoutingPartitionSize = propRoutingPartitionSize.Value,
			RoutingPath = propRoutingPath.Value,
			Search = propSearch.Value,
			Settings = propSettings.Value,
			Similarity = propSimilarity.Value,
			SoftDeletes = propSoftDeletes.Value,
			Sort = propSort.Value,
			Store = propStore.Value,
			TimeSeries = propTimeSeries.Value,
			TopMetricsMaxSize = propTopMetricsMaxSize.Value,
			Translog = propTranslog.Value,
			Uuid = propUuid.Value,
			VerifiedBeforeClose = propVerifiedBeforeClose.Value,
			Version = propVersion.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAnalysis, value.Analysis, null, null);
		writer.WriteProperty(options, PropAnalyze, value.Analyze, null, null);
		writer.WriteProperty(options, PropAutoExpandReplicas, value.AutoExpandReplicas, null, null);
		writer.WriteProperty(options, PropBlocks, value.Blocks, null, null);
		writer.WriteProperty(options, PropCheckOnStartup, value.CheckOnStartup, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.IndexManagement.IndexCheckOnStartup? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexCheckOnStartup>(o, v));
		writer.WriteProperty(options, PropCodec, value.Codec, null, null);
		writer.WriteProperty(options, PropCreationDate, value.CreationDate, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset? v) => w.WriteNullableValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropCreationDateString, value.CreationDateString, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset? v) => w.WriteNullableValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMarker)));
		writer.WriteProperty(options, PropDefaultPipeline, value.DefaultPipeline, null, null);
		writer.WriteProperty(options, PropFinalPipeline, value.FinalPipeline, null, null);
		writer.WriteProperty(options, PropFormat, value.Format, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Union<string, int>? v) => w.WriteUnionValue<string, int>(o, v, null, null));
		writer.WriteProperty(options, PropGcDeletes, value.GcDeletes, null, null);
		writer.WriteProperty(options, PropHidden, value.Hidden, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Union<bool, string>? v) => w.WriteUnionValue<bool, string>(o, v, null, null));
		writer.WriteProperty(options, PropHighlight, value.Highlight, null, null);
		writer.WriteProperty(options, PropIndex, value.Index, null, null);
		writer.WriteProperty(options, PropIndexingPressure, value.IndexingPressure, null, null);
		writer.WriteProperty(options, PropIndexingSlowlog, value.IndexingSlowlog, null, null);
		writer.WriteProperty(options, PropLifecycle, value.Lifecycle, null, null);
		writer.WriteProperty(options, PropLoadFixedBitsetFiltersEagerly, value.LoadFixedBitsetFiltersEagerly, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropMapping, value.Mapping, null, null);
		writer.WriteProperty(options, PropMaxDocvalueFieldsSearch, value.MaxDocvalueFieldsSearch, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxInnerResultWindow, value.MaxInnerResultWindow, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxNgramDiff, value.MaxNgramDiff, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxRefreshListeners, value.MaxRefreshListeners, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxRegexLength, value.MaxRegexLength, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxRescoreWindow, value.MaxRescoreWindow, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxResultWindow, value.MaxResultWindow, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxScriptFields, value.MaxScriptFields, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxShingleDiff, value.MaxShingleDiff, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxSlicesPerScroll, value.MaxSlicesPerScroll, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMaxTermsCount, value.MaxTermsCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropMerge, value.Merge, null, null);
		writer.WriteProperty(options, PropMode, value.Mode, null, null);
		writer.WriteProperty(options, PropNumberOfReplicas, value.NumberOfReplicas, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Union<int, string>? v) => w.WriteUnionValue<int, string>(o, v, null, null));
		writer.WriteProperty(options, PropNumberOfRoutingShards, value.NumberOfRoutingShards, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropNumberOfShards, value.NumberOfShards, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Union<int, string>? v) => w.WriteUnionValue<int, string>(o, v, null, null));
		writer.WriteProperty(options, PropPriority, value.Priority, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Union<int, string>? v) => w.WriteUnionValue<int, string>(o, v, null, null));
		writer.WriteProperty(options, PropProvidedName, value.ProvidedName, null, null);
		writer.WriteProperty(options, PropQueries, value.Queries, null, null);
		writer.WriteProperty(options, PropQueryString, value.QueryString, null, null);
		writer.WriteProperty(options, PropRefreshInterval, value.RefreshInterval, null, null);
		writer.WriteProperty(options, PropRouting, value.Routing, null, null);
		writer.WriteProperty(options, PropRoutingPartitionSize, value.RoutingPartitionSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropRoutingPath, value.RoutingPath, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteSingleOrManyCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropSearch, value.Search, null, null);
		writer.WriteProperty(options, PropSettings, value.Settings, null, null);
		writer.WriteProperty(options, PropSimilarity, value.Similarity, null, null);
		writer.WriteProperty(options, PropSoftDeletes, value.SoftDeletes, null, null);
		writer.WriteProperty(options, PropSort, value.Sort, null, null);
		writer.WriteProperty(options, PropStore, value.Store, null, null);
		writer.WriteProperty(options, PropTimeSeries, value.TimeSeries, null, null);
		writer.WriteProperty(options, PropTopMetricsMaxSize, value.TopMetricsMaxSize, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropTranslog, value.Translog, null, null);
		writer.WriteProperty(options, PropUuid, value.Uuid, null, null);
		writer.WriteProperty(options, PropVerifiedBeforeClose, value.VerifiedBeforeClose, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.Union<bool, string>? v) => w.WriteUnionValue<bool, string>(o, v, null, null));
		writer.WriteProperty(options, PropVersion, value.Version, null, null);
		if (value.OtherSettings is not null)
		{
			foreach (var item in value.OtherSettings)
			{
				writer.WriteProperty(options, item.Key, item.Value, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, string v) => w.WritePropertyName<string>(o, v), static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, object v) => w.WriteValueEx<object>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.SourceMarker<object>)));
			}
		}

		writer.WriteEndObject();
	}
}