// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.IndexSettingResultsConverter))]
public sealed partial class IndexSettingResults
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexSettingResults(System.Collections.Generic.IReadOnlyCollection<string> appliedToDataStreamAndBackingIndices, System.Collections.Generic.IReadOnlyCollection<string> appliedToDataStreamOnly)
	{
		AppliedToDataStreamAndBackingIndices = appliedToDataStreamAndBackingIndices;
		AppliedToDataStreamOnly = appliedToDataStreamOnly;
	}
#if NET7_0_OR_GREATER
	public IndexSettingResults()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IndexSettingResults()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexSettingResults(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The list of settings that were applied to the data stream and to all of its backing indices. These settings will
	/// also be applied to the write index the next time the data stream is rolled over.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> AppliedToDataStreamAndBackingIndices { get; set; }

	/// <summary>
	/// <para>
	/// The list of settings that were applied to the data stream but not to backing indices. These will be applied to
	/// the write index the next time the data stream is rolled over.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> AppliedToDataStreamOnly { get; set; }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamSettingsError>? Errors { get; set; }
}