// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class IndexRoutingAllocationOptionsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAll = System.Text.Json.JsonEncodedText.Encode("all");
	private static readonly System.Text.Json.JsonEncodedText MemberNewPrimaries = System.Text.Json.JsonEncodedText.Encode("new_primaries");
	private static readonly System.Text.Json.JsonEncodedText MemberNone = System.Text.Json.JsonEncodedText.Encode("none");
	private static readonly System.Text.Json.JsonEncodedText MemberPrimaries = System.Text.Json.JsonEncodedText.Encode("primaries");

	public override Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAll))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.All;
		}

		if (reader.ValueTextEquals(MemberNewPrimaries))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.NewPrimaries;
		}

		if (reader.ValueTextEquals(MemberNone))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.None;
		}

		if (reader.ValueTextEquals(MemberPrimaries))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.Primaries;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAll.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.All;
		}

		if (string.Equals(value, MemberNewPrimaries.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.NewPrimaries;
		}

		if (string.Equals(value, MemberNone.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.None;
		}

		if (string.Equals(value, MemberPrimaries.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.Primaries;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.All:
				writer.WriteStringValue(MemberAll);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.NewPrimaries:
				writer.WriteStringValue(MemberNewPrimaries);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.None:
				writer.WriteStringValue(MemberNone);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions.Primaries:
				writer.WriteStringValue(MemberPrimaries);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationOptions value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}