// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.IndexRoutingConverter))]
public sealed partial class IndexRouting
{
#if NET7_0_OR_GREATER
	public IndexRouting()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IndexRouting()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexRouting(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocation? Allocation { get; set; }
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingRebalance? Rebalance { get; set; }
}

public readonly partial struct IndexRoutingDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexRoutingDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexRoutingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting(Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor Allocation(Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocation? value)
	{
		Instance.Allocation = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor Allocation()
	{
		Instance.Allocation = Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor Allocation(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationDescriptor>? action)
	{
		Instance.Allocation = Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingAllocationDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor Rebalance(Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingRebalance? value)
	{
		Instance.Rebalance = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor Rebalance(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingRebalanceDescriptor> action)
	{
		Instance.Rebalance = Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingRebalanceDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexRoutingDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.IndexRouting(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}