// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.IndexModifyDataStreamActionConverter))]
public sealed partial class IndexModifyDataStreamAction
{
	internal string? VariantType { get; set; }
	internal object? Variant { get; set; }
#if NET7_0_OR_GREATER
	public IndexModifyDataStreamAction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public IndexModifyDataStreamAction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexModifyDataStreamAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Adds an existing index as a backing index for a data stream.
	/// The index is hidden as part of this operation.
	/// WARNING: Adding indices with the <c>add_backing_index</c> action can potentially result in improper data stream behavior.
	/// This should be considered an expert level API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexAndDataStreamAction? AddBackingIndex { get => GetVariant<Elastic.Clients.Elasticsearch.IndexManagement.IndexAndDataStreamAction>("add_backing_index"); set => SetVariant("add_backing_index", value); }

	/// <summary>
	/// <para>
	/// Removes a backing index from a data stream.
	/// The index is unhidden as part of this operation.
	/// A data stream’s write index cannot be removed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexAndDataStreamAction? RemoveBackingIndex { get => GetVariant<Elastic.Clients.Elasticsearch.IndexManagement.IndexAndDataStreamAction>("remove_backing_index"); set => SetVariant("remove_backing_index", value); }

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private T? GetVariant<T>(string type)
	{
		if (string.Equals(VariantType, type, System.StringComparison.Ordinal) && Variant is T result)
		{
			return result;
		}

		return default;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	private void SetVariant<T>(string type, T? value)
	{
		VariantType = type;
		Variant = value;
	}
}

public readonly partial struct IndexModifyDataStreamActionDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamAction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexModifyDataStreamActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamAction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexModifyDataStreamActionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamAction instance) => new Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamActionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamAction(Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamActionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Adds an existing index as a backing index for a data stream.
	/// The index is hidden as part of this operation.
	/// WARNING: Adding indices with the <c>add_backing_index</c> action can potentially result in improper data stream behavior.
	/// This should be considered an expert level API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamActionDescriptor AddBackingIndex(Elastic.Clients.Elasticsearch.IndexManagement.IndexAndDataStreamAction? value)
	{
		Instance.AddBackingIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Adds an existing index as a backing index for a data stream.
	/// The index is hidden as part of this operation.
	/// WARNING: Adding indices with the <c>add_backing_index</c> action can potentially result in improper data stream behavior.
	/// This should be considered an expert level API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamActionDescriptor AddBackingIndex(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexAndDataStreamActionDescriptor> action)
	{
		Instance.AddBackingIndex = Elastic.Clients.Elasticsearch.IndexManagement.IndexAndDataStreamActionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Removes a backing index from a data stream.
	/// The index is unhidden as part of this operation.
	/// A data stream’s write index cannot be removed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamActionDescriptor RemoveBackingIndex(Elastic.Clients.Elasticsearch.IndexManagement.IndexAndDataStreamAction? value)
	{
		Instance.RemoveBackingIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Removes a backing index from a data stream.
	/// The index is unhidden as part of this operation.
	/// A data stream’s write index cannot be removed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamActionDescriptor RemoveBackingIndex(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexAndDataStreamActionDescriptor> action)
	{
		Instance.RemoveBackingIndex = Elastic.Clients.Elasticsearch.IndexManagement.IndexAndDataStreamActionDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamAction Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamActionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamActionDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.IndexModifyDataStreamAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}