// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class IndexModeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.IndexMode>
{
	private static readonly System.Text.Json.JsonEncodedText MemberLogsdb = System.Text.Json.JsonEncodedText.Encode("logsdb");
	private static readonly System.Text.Json.JsonEncodedText MemberLookup = System.Text.Json.JsonEncodedText.Encode("lookup");
	private static readonly System.Text.Json.JsonEncodedText MemberStandard = System.Text.Json.JsonEncodedText.Encode("standard");
	private static readonly System.Text.Json.JsonEncodedText MemberTimeSeries = System.Text.Json.JsonEncodedText.Encode("time_series");

	public override Elastic.Clients.Elasticsearch.IndexManagement.IndexMode Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberLogsdb))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.Logsdb;
		}

		if (reader.ValueTextEquals(MemberLookup))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.Lookup;
		}

		if (reader.ValueTextEquals(MemberStandard))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.Standard;
		}

		if (reader.ValueTextEquals(MemberTimeSeries))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.TimeSeries;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberLogsdb.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.Logsdb;
		}

		if (string.Equals(value, MemberLookup.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.Lookup;
		}

		if (string.Equals(value, MemberStandard.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.Standard;
		}

		if (string.Equals(value, MemberTimeSeries.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.TimeSeries;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.IndexMode)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.IndexMode value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.Logsdb:
				writer.WriteStringValue(MemberLogsdb);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.Lookup:
				writer.WriteStringValue(MemberLookup);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.Standard:
				writer.WriteStringValue(MemberStandard);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.IndexMode.TimeSeries:
				writer.WriteStringValue(MemberTimeSeries);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.IndexMode)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.IndexMode ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.IndexMode value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}