// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class FeatureConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.Feature>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAliases = System.Text.Json.JsonEncodedText.Encode("aliases");
	private static readonly System.Text.Json.JsonEncodedText MemberMappings = System.Text.Json.JsonEncodedText.Encode("mappings");
	private static readonly System.Text.Json.JsonEncodedText MemberSettings = System.Text.Json.JsonEncodedText.Encode("settings");

	public override Elastic.Clients.Elasticsearch.IndexManagement.Feature Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAliases))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.Feature.Aliases;
		}

		if (reader.ValueTextEquals(MemberMappings))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.Feature.Mappings;
		}

		if (reader.ValueTextEquals(MemberSettings))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.Feature.Settings;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAliases.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.Feature.Aliases;
		}

		if (string.Equals(value, MemberMappings.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.Feature.Mappings;
		}

		if (string.Equals(value, MemberSettings.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IndexManagement.Feature.Settings;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.Feature)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.Feature value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IndexManagement.Feature.Aliases:
				writer.WriteStringValue(MemberAliases);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.Feature.Mappings:
				writer.WriteStringValue(MemberMappings);
				break;
			case Elastic.Clients.Elasticsearch.IndexManagement.Feature.Settings:
				writer.WriteStringValue(MemberSettings);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IndexManagement.Feature)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IndexManagement.Feature ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.Feature value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}