// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

/// <summary>
/// <para>
/// Template equivalent of FailureStoreLifecycle that allows nullable values.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.FailureStoreLifecycleTemplateConverter))]
public sealed partial class FailureStoreLifecycleTemplate
{
#if NET7_0_OR_GREATER
	public FailureStoreLifecycleTemplate()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public FailureStoreLifecycleTemplate()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FailureStoreLifecycleTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If defined, every document added to this data stream will be stored at least for this time frame.
	/// Any time after this duration the document could be deleted.
	/// When empty, every document in this data stream will be stored indefinitely.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? DataRetention { get; set; }

	/// <summary>
	/// <para>
	/// If defined, it turns data stream lifecycle on/off (<c>true</c>/<c>false</c>) for this data stream. A data stream lifecycle
	/// that's disabled (enabled: <c>false</c>) will have no effect on the data stream.
	/// </para>
	/// </summary>
	public bool? Enabled { get; set; }
}

/// <summary>
/// <para>
/// Template equivalent of FailureStoreLifecycle that allows nullable values.
/// </para>
/// </summary>
public readonly partial struct FailureStoreLifecycleTemplateDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplate Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FailureStoreLifecycleTemplateDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplate instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FailureStoreLifecycleTemplateDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplateDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplate instance) => new Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplateDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplate(Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplateDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If defined, every document added to this data stream will be stored at least for this time frame.
	/// Any time after this duration the document could be deleted.
	/// When empty, every document in this data stream will be stored indefinitely.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplateDescriptor DataRetention(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.DataRetention = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, it turns data stream lifecycle on/off (<c>true</c>/<c>false</c>) for this data stream. A data stream lifecycle
	/// that's disabled (enabled: <c>false</c>) will have no effect on the data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplateDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplate Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplateDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplateDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}