// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

/// <summary>
/// <para>
/// The failure store lifecycle configures the data stream lifecycle configuration for failure indices.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.FailureStoreLifecycleConverter))]
public sealed partial class FailureStoreLifecycle
{
#if NET7_0_OR_GREATER
	public FailureStoreLifecycle()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public FailureStoreLifecycle()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FailureStoreLifecycle(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If defined, every document added to this data stream will be stored at least for this time frame.
	/// Any time after this duration the document could be deleted.
	/// When empty, every document in this data stream will be stored indefinitely.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? DataRetention { get; set; }

	/// <summary>
	/// <para>
	/// If defined, it turns data stream lifecycle on/off (<c>true</c>/<c>false</c>) for this data stream. A data stream lifecycle
	/// that's disabled (enabled: <c>false</c>) will have no effect on the data stream.
	/// </para>
	/// </summary>
	public bool? Enabled { get; set; }
}

/// <summary>
/// <para>
/// The failure store lifecycle configures the data stream lifecycle configuration for failure indices.
/// </para>
/// </summary>
public readonly partial struct FailureStoreLifecycleDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycle Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FailureStoreLifecycleDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycle instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FailureStoreLifecycleDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycle(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycle instance) => new Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycle(Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If defined, every document added to this data stream will be stored at least for this time frame.
	/// Any time after this duration the document could be deleted.
	/// When empty, every document in this data stream will be stored indefinitely.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleDescriptor DataRetention(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.DataRetention = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, it turns data stream lifecycle on/off (<c>true</c>/<c>false</c>) for this data stream. A data stream lifecycle
	/// that's disabled (enabled: <c>false</c>) will have no effect on the data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycle Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycle(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycle(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}