// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DownsampleConfigConverter))]
public sealed partial class DownsampleConfig
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DownsampleConfig(string fixedInterval)
	{
		FixedInterval = fixedInterval;
	}
#if NET7_0_OR_GREATER
	public DownsampleConfig()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DownsampleConfig()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DownsampleConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The interval at which to aggregate the original time series index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string FixedInterval { get; set; }
}

public readonly partial struct DownsampleConfigDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DownsampleConfigDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DownsampleConfigDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfigDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig instance) => new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfigDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig(Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfigDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The interval at which to aggregate the original time series index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfigDescriptor FixedInterval(string value)
	{
		Instance.FixedInterval = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfigDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfigDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.DownsampleConfig(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}