// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DataStreamsStatsItemConverter))]
public sealed partial class DataStreamsStatsItem
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamsStatsItem(int backingIndices, string dataStream, System.DateTimeOffset maximumTimestamp, long storeSizeBytes)
	{
		BackingIndices = backingIndices;
		DataStream = dataStream;
		MaximumTimestamp = maximumTimestamp;
		StoreSizeBytes = storeSizeBytes;
	}
#if NET7_0_OR_GREATER
	public DataStreamsStatsItem()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DataStreamsStatsItem()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataStreamsStatsItem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Current number of backing indices for the data stream.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int BackingIndices { get; set; }

	/// <summary>
	/// <para>
	/// Name of the data stream.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string DataStream { get; set; }

	/// <summary>
	/// <para>
	/// The data stream’s highest <c>@timestamp</c> value, converted to milliseconds since the Unix epoch.
	/// NOTE: This timestamp is provided as a best effort.
	/// The data stream may contain <c>@timestamp</c> values higher than this if one or more of the following conditions are met:
	/// The stream contains closed backing indices;
	/// Backing indices with a lower generation contain higher <c>@timestamp</c> values.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset MaximumTimestamp { get; set; }

	/// <summary>
	/// <para>
	/// Total size of all shards for the data stream’s backing indices.
	/// This parameter is only returned if the <c>human</c> query parameter is <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? StoreSize { get; set; }

	/// <summary>
	/// <para>
	/// Total size, in bytes, of all shards for the data stream’s backing indices.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long StoreSizeBytes { get; set; }
}