// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class DataStreamsStatsItemConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsItem>
{
	private static readonly System.Text.Json.JsonEncodedText PropBackingIndices = System.Text.Json.JsonEncodedText.Encode("backing_indices");
	private static readonly System.Text.Json.JsonEncodedText PropDataStream = System.Text.Json.JsonEncodedText.Encode("data_stream");
	private static readonly System.Text.Json.JsonEncodedText PropMaximumTimestamp = System.Text.Json.JsonEncodedText.Encode("maximum_timestamp");
	private static readonly System.Text.Json.JsonEncodedText PropStoreSize = System.Text.Json.JsonEncodedText.Encode("store_size");
	private static readonly System.Text.Json.JsonEncodedText PropStoreSizeBytes = System.Text.Json.JsonEncodedText.Encode("store_size_bytes");

	public override Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsItem Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propBackingIndices = default;
		LocalJsonValue<string> propDataStream = default;
		LocalJsonValue<System.DateTimeOffset> propMaximumTimestamp = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propStoreSize = default;
		LocalJsonValue<long> propStoreSizeBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBackingIndices.TryReadProperty(ref reader, options, PropBackingIndices, null))
			{
				continue;
			}

			if (propDataStream.TryReadProperty(ref reader, options, PropDataStream, null))
			{
				continue;
			}

			if (propMaximumTimestamp.TryReadProperty(ref reader, options, PropMaximumTimestamp, static System.DateTimeOffset (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker))))
			{
				continue;
			}

			if (propStoreSize.TryReadProperty(ref reader, options, PropStoreSize, null))
			{
				continue;
			}

			if (propStoreSizeBytes.TryReadProperty(ref reader, options, PropStoreSizeBytes, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsItem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			BackingIndices = propBackingIndices.Value,
			DataStream = propDataStream.Value,
			MaximumTimestamp = propMaximumTimestamp.Value,
			StoreSize = propStoreSize.Value,
			StoreSizeBytes = propStoreSizeBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamsStatsItem value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBackingIndices, value.BackingIndices, null, null);
		writer.WriteProperty(options, PropDataStream, value.DataStream, null, null);
		writer.WriteProperty(options, PropMaximumTimestamp, value.MaximumTimestamp, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset v) => w.WriteValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMillisMarker)));
		writer.WriteProperty(options, PropStoreSize, value.StoreSize, null, null);
		writer.WriteProperty(options, PropStoreSizeBytes, value.StoreSizeBytes, null, null);
		writer.WriteEndObject();
	}
}