// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

/// <summary>
/// <para>
/// Data stream options template contains the same information as DataStreamOptions but allows them to be set explicitly to null.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DataStreamOptionsTemplateConverter))]
public sealed partial class DataStreamOptionsTemplate
{
#if NET7_0_OR_GREATER
	public DataStreamOptionsTemplate()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DataStreamOptionsTemplate()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataStreamOptionsTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplate? FailureStore { get; set; }
}

/// <summary>
/// <para>
/// Data stream options template contains the same information as DataStreamOptions but allows them to be set explicitly to null.
/// </para>
/// </summary>
public readonly partial struct DataStreamOptionsTemplateDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplate Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamOptionsTemplateDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplate instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamOptionsTemplateDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplateDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplate instance) => new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplateDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplate(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplateDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplateDescriptor FailureStore(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplate? value)
	{
		Instance.FailureStore = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplateDescriptor FailureStore()
	{
		Instance.FailureStore = Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplateDescriptor FailureStore(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor>? action)
	{
		Instance.FailureStore = Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplate Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplateDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplateDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamOptionsTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}