// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DataStreamLifecycleRolloverConditionsConverter))]
public sealed partial class DataStreamLifecycleRolloverConditions
{
#if NET7_0_OR_GREATER
	public DataStreamLifecycleRolloverConditions()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DataStreamLifecycleRolloverConditions()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataStreamLifecycleRolloverConditions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? MaxAge { get; set; }
	public long? MaxDocs { get; set; }
	public long? MaxPrimaryShardDocs { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MaxPrimaryShardSize { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MaxSize { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? MinAge { get; set; }
	public long? MinDocs { get; set; }
	public long? MinPrimaryShardDocs { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MinPrimaryShardSize { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MinSize { get; set; }
}

public readonly partial struct DataStreamLifecycleRolloverConditionsDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditions Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamLifecycleRolloverConditionsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditions instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamLifecycleRolloverConditionsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditions instance) => new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditions(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MaxAge(string? value)
	{
		Instance.MaxAge = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MaxDocs(long? value)
	{
		Instance.MaxDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MaxPrimaryShardDocs(long? value)
	{
		Instance.MaxPrimaryShardDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MaxPrimaryShardSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxPrimaryShardSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MaxPrimaryShardSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxPrimaryShardSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MaxSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MaxSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MinAge(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MinAge = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MinDocs(long? value)
	{
		Instance.MinDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MinPrimaryShardDocs(long? value)
	{
		Instance.MinPrimaryShardDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MinPrimaryShardSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MinPrimaryShardSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MinPrimaryShardSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MinPrimaryShardSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MinSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MinSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor MinSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MinSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditions Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditionsDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleRolloverConditions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}