// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DataStreamLifecycleDownsamplingConverter))]
public sealed partial class DataStreamLifecycleDownsampling
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamLifecycleDownsampling(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexManagement.DownsamplingRound> rounds)
	{
		Rounds = rounds;
	}
#if NET7_0_OR_GREATER
	public DataStreamLifecycleDownsampling()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DataStreamLifecycleDownsampling()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataStreamLifecycleDownsampling(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The list of downsampling rounds to execute as part of this downsampling configuration
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexManagement.DownsamplingRound> Rounds { get; set; }
}

public readonly partial struct DataStreamLifecycleDownsamplingDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsampling Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamLifecycleDownsamplingDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsampling instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamLifecycleDownsamplingDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsampling(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsamplingDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsampling instance) => new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsamplingDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsampling(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsamplingDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The list of downsampling rounds to execute as part of this downsampling configuration
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsamplingDescriptor Rounds(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexManagement.DownsamplingRound> value)
	{
		Instance.Rounds = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The list of downsampling rounds to execute as part of this downsampling configuration
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsamplingDescriptor Rounds(params Elastic.Clients.Elasticsearch.IndexManagement.DownsamplingRound[] values)
	{
		Instance.Rounds = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The list of downsampling rounds to execute as part of this downsampling configuration
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsamplingDescriptor Rounds(params System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DownsamplingRoundDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.IndexManagement.DownsamplingRound>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.IndexManagement.DownsamplingRoundDescriptor.Build(action));
		}

		Instance.Rounds = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsampling Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsamplingDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsamplingDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleDownsampling(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}