// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DataStreamIndexConverter))]
public sealed partial class DataStreamIndex
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamIndex(string indexName, string indexUuid)
	{
		IndexName = indexName;
		IndexUuid = indexUuid;
	}
#if NET7_0_OR_GREATER
	public DataStreamIndex()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DataStreamIndex()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataStreamIndex(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Name of the current ILM lifecycle policy configured for this backing index.
	/// </para>
	/// </summary>
	public string? IlmPolicy { get; set; }

	/// <summary>
	/// <para>
	/// The index mode of this backing index of the data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexMode? IndexMode { get; set; }

	/// <summary>
	/// <para>
	/// Name of the backing index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string IndexName { get; set; }

	/// <summary>
	/// <para>
	/// Universally unique identifier (UUID) for the index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string IndexUuid { get; set; }

	/// <summary>
	/// <para>
	/// Name of the lifecycle system that's currently managing this backing index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy? ManagedBy { get; set; }

	/// <summary>
	/// <para>
	/// Indicates if ILM should take precedence over DSL in case both are configured to manage this index.
	/// </para>
	/// </summary>
	public bool? PreferIlm { get; set; }
}